/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.analyzers.FuncRecord;
import ghidra.app.analyzers.LibraryRecord;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.TreeSet;

public class LibHashDB {
    private TreeSet<LibraryRecord> libraries = new TreeSet();

    public LibHashDB() {
    }

    public LibHashDB(Program prgm) throws CancelledException {
        this.libraries.add(new LibraryRecord(prgm));
    }

    public void mergeWith(LibHashDB toMergeIn) {
        this.libraries.addAll(toMergeIn.libraries);
    }

    public void addLibrary(LibraryRecord libRec) {
        this.libraries.add(libRec);
    }

    public TreeSet<FuncRecord> getRecords() {
        TreeSet<FuncRecord> results = new TreeSet<FuncRecord>();
        for (LibraryRecord lib : this.libraries) {
            results.addAll(lib.getRecords());
        }
        return results;
    }

    public ArrayList<FuncRecord> query(Function func) throws CancelledException {
        FuncRecord queryHash = new FuncRecord(func);
        ArrayList<FuncRecord> result = this.query(queryHash.hashValue);
        for (FuncRecord entry : result) {
            if (entry.func != func) continue;
            ArrayList<FuncRecord> newResult = new ArrayList<FuncRecord>();
            newResult.add(entry);
            return newResult;
        }
        return result;
    }

    public ArrayList<FuncRecord> query(Long hash) {
        ArrayList<FuncRecord> result = new ArrayList<FuncRecord>();
        FuncRecord temp = new FuncRecord();
        temp.hashValue = hash;
        for (LibraryRecord libRec : this.libraries) {
            result.addAll(libRec.query(hash));
        }
        return result;
    }

    public void restoreXml(XmlPullParser parser) {
        parser.start(new String[]{"funcDB"});
        while (parser.peek().isStart()) {
            LibraryRecord libRec = new LibraryRecord();
            libRec.restoreXml(parser);
            this.addLibrary(libRec);
        }
        parser.end();
    }

    public void saveXml(Writer fwrite) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<funcDB>\n");
        fwrite.append(buf.toString());
        for (LibraryRecord libRec : this.libraries) {
            libRec.saveXml(fwrite);
        }
        fwrite.append("</funcDB>\n");
    }
}

