/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.CodeUnitTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;
import ghidra.util.task.TaskMonitor;

public abstract class AddressBasedTableModel<ROW_TYPE>
extends GhidraProgramTableModel<ROW_TYPE> {
    public AddressBasedTableModel(String title, ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        this(title, serviceProvider, program, monitor, false);
    }

    public AddressBasedTableModel(String title, ServiceProvider serviceProvider, Program program, TaskMonitor monitor, boolean loadIncrementally) {
        super(title, serviceProvider, program, monitor, loadIncrementally);
    }

    public abstract Address getAddress(int var1);

    protected TableColumnDescriptor<ROW_TYPE> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new CodeUnitTableColumn()));
        return descriptor;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        ProgramLocationTableColumn programField;
        ProgramLocation loc;
        if (row < 0 || row >= this.filteredData.size()) {
            return null;
        }
        Object rowObject = this.filteredData.get(row);
        DynamicTableColumn tableColumn = this.getColumn(column);
        if (tableColumn != null && tableColumn instanceof ProgramLocationTableColumn && (loc = (programField = (ProgramLocationTableColumn)tableColumn).getProgramLocation(rowObject, this.getColumnSettings(column), this.getProgram(), this.serviceProvider)) != null) {
            return loc;
        }
        Address address = this.getAddress(row, column);
        if (address != null) {
            return new ProgramLocation(this.getProgram(), address);
        }
        return null;
    }

    private Address getAddress(int row, int column) {
        Object storageValue;
        Object columnValueForRow;
        DynamicTableColumn tableColumn = this.getColumn(column);
        if (tableColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programLocationColumn = (ProgramLocationTableColumn)tableColumn;
            Settings settings = this.getColumnSettings(column);
            Object rowObject = this.filteredData.get(row);
            Object value = programLocationColumn.getValue(rowObject, settings, this.getProgram(), this.serviceProvider);
            if (value instanceof Address) {
                return (Address)value;
            }
            if (value instanceof ProgramLocation) {
                ProgramLocation programLocation = (ProgramLocation)value;
                return programLocation.getByteAddress();
            }
            ProgramLocation location = programLocationColumn.getProgramLocation(rowObject, settings, this.getProgram(), this.serviceProvider);
            if (location != null) {
                return location.getByteAddress();
            }
        }
        if ((columnValueForRow = this.getColumnValueForRow(storageValue = this.filteredData.get(row), column)) instanceof Address) {
            return (Address)columnValueForRow;
        }
        return this.getAddress(row);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet addressSet = new AddressSet();
        for (int element : rows) {
            Address addr = this.getAddress(element);
            if (!addr.isMemoryAddress()) continue;
            addressSet.addRange(addr, addr);
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

