/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.state.ContextState;
import ghidra.util.state.FunctionAnalyzer;
import ghidra.util.state.ResultsState;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.state.analysis.Switch;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;
import java.util.List;

public class MySwitchAnalyzer
implements FunctionAnalyzer {
    private final Program program;
    private final AddressFactory addrFactory;
    private final Listing listing;
    private ReferenceManager refMgr;

    public MySwitchAnalyzer(Program program) {
        this.program = program;
        this.addrFactory = program.getAddressFactory();
        this.listing = program.getListing();
        this.refMgr = program.getReferenceManager();
    }

    public static ResultsState analyze(Program program, Address functionEntry, TaskMonitor monitor) throws CancelledException {
        long t = System.currentTimeMillis();
        MySwitchAnalyzer analyzer = new MySwitchAnalyzer(program);
        ResultsState s = new ResultsState(functionEntry, (FunctionAnalyzer)analyzer, program, true, monitor);
        t = System.currentTimeMillis() - t;
        System.out.println("Time to build ResultState = " + t + " msec.");
        return s;
    }

    private void addReference(PcodeOp flowOp, Address toAddr) {
        Address flowFrom = flowOp.getSeqnum().getTarget();
        Instruction fromInstr = this.listing.getInstructionAt(flowFrom);
        for (Reference ref : fromInstr.getReferencesFrom()) {
            if (!toAddr.equals((Object)ref.getToAddress())) continue;
            return;
        }
        FlowType ftype = fromInstr.getFlowType();
        fromInstr.addMnemonicReference(toAddr, (RefType)ftype, SourceType.ANALYSIS);
    }

    public boolean resolvedFlow(PcodeOp op, Object opIndex, Address destAddr, ContextState currentState, ResultsState results, TaskMonitor monitor) {
        this.addReference(op, destAddr);
        return true;
    }

    public List<Address> unresolvedIndirectFlow(PcodeOp op, Object opIndex, Varnode destination, ContextState currentState, ResultsState results, TaskMonitor monitor) {
        if (destination instanceof VarnodeOperation) {
            VarnodeOperation dest = (VarnodeOperation)destination;
            return this.handleOffsetSwitchOperation(op, dest, currentState, results, monitor);
        }
        return null;
    }

    private Address getAddress(long offset) {
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    private List<Address> handleOffsetSwitchOperation(PcodeOp op, VarnodeOperation destAddOp, ContextState currentState, ResultsState results, TaskMonitor monitor) {
        ContextState state;
        Varnode indexValue;
        Msg.debug((Object)this, (Object)("State-entry: " + currentState.getEntryPoint()));
        for (SequenceNumber seq : currentState.getFlowFroms()) {
            Msg.debug((Object)this, (Object)("State-flowFrom: " + seq));
        }
        Switch s = Switch.getIndirectJumpSwitch(this.program, destAddOp);
        if (s == null) {
            Msg.debug((Object)this, (Object)("Unsupported indirect call at: " + op.getSeqnum().getTarget()));
            return null;
        }
        Msg.debug((Object)this, (Object)("Processing switch at: " + op.getSeqnum().getTarget()));
        Msg.debug((Object)this, (Object)("Switch class: " + s.getClass().getName()));
        Varnode indexValueVarnode = indexValue = s.getIndexValue();
        SequenceNumber indexValueAssignedAt = null;
        Msg.debug((Object)this, (Object)("Switch index expression: " + indexValue));
        if (indexValue instanceof VarnodeOperation) {
            VarnodeOperation indexValueOp = (VarnodeOperation)indexValue;
            indexValueVarnode = indexValueOp.getPCodeOp().getOutput();
            Msg.debug((Object)this, (Object)("Switch index variable: " + indexValueVarnode));
            indexValueAssignedAt = indexValueOp.getPCodeOp().getSeqnum();
            Msg.debug((Object)this, (Object)("Switch index variable assigned at: " + indexValueAssignedAt));
        } else {
            Msg.debug((Object)this, (Object)"Switch index is input parameter!");
        }
        LinkedList<SequenceNumber> flowList = new LinkedList<SequenceNumber>();
        flowList.addFirst(currentState.getEntryPoint());
        boolean stopRewind = false;
        for (state = currentState; state != null && !stopRewind; state = state.getPreviousContextState()) {
            flowList.addFirst(state.getEntryPoint());
            stopRewind = indexValueAssignedAt != null && state.getSequenceRange().contains(indexValueAssignedAt);
        }
        if (state == null) {
            state = new ContextState(results.getEntryPoint().getTarget(), this.program);
        }
        Msg.debug((Object)this, (Object)("Rewind state to: " + state.getEntryPoint()));
        return null;
    }

    private Register findSingleRegister(Varnode value) {
        if (value instanceof VarnodeOperation) {
            Register reg = null;
            for (Varnode input : ((VarnodeOperation)value).getInputValues()) {
                Register inputReg = this.findSingleRegister(input);
                if (inputReg == null) continue;
                if (reg != null && !reg.equals((Object)inputReg)) {
                    throw new MultipleRegInputsException();
                }
                reg = inputReg;
            }
            return reg;
        }
        if (value.isAddress() || value.isRegister()) {
            return this.program.getRegister(value.getAddress(), value.getSize());
        }
        return null;
    }

    @Override
    public void dataReference(PcodeOp op, int instrOpIndex, Varnode storageVarnode, RefType refType, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void indirectDataReference(PcodeOp op, int instrOpIndex, Varnode offsetVarnode, int size, int storageSpaceID, RefType refType, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public boolean resolvedFlow(PcodeOp op, int instrOpIndex, Address destAddr, ContextState currentState, ResultsState results, TaskMonitor monitor) throws CancelledException {
        return false;
    }

    @Override
    public void stackReference(PcodeOp op, int instrOpIndex, int stackOffset, int size, int storageSpaceID, RefType refType, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public void stackReference(PcodeOp op, int instrOpIndex, VarnodeOperation computedStackOffset, int size, int storageSpaceID, RefType refType, TaskMonitor monitor) throws CancelledException {
    }

    @Override
    public List<Address> unresolvedIndirectFlow(PcodeOp op, int instrOpIndex, Varnode destination, ContextState currentState, ResultsState results, TaskMonitor monitor) throws CancelledException {
        return null;
    }

    private static class MultipleRegInputsException
    extends RuntimeException {
        private MultipleRegInputsException() {
        }
    }
}

