/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalManagedBufferFile;
import generic.test.AbstractGTest;
import generic.test.AbstractGenericTest;
import ghidra.app.util.importer.MemoryConflictHandler;
import ghidra.app.util.xml.ProgramInfo;
import ghidra.app.util.xml.ProgramXmlMgr;
import ghidra.app.util.xml.XmlProgramOptions;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.store.db.PrivateDatabase;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.ProcessorNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.ConsoleTaskMonitor;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import utilities.util.FileUtilities;

public class TestProgramManager {
    private final Map<String, PrivateDatabase> testPrograms = new HashMap<String, PrivateDatabase>();
    private final Set<Program> openTestPrograms = new HashSet<Program>();
    private static final String DB_DIR_NAME = "db";
    private static File dbTestDir;

    public void add(Program p) {
        this.openTestPrograms.add(p);
    }

    public ProgramDB getProgram(String progName) {
        if (progName.endsWith(".gzf")) {
            progName = progName.substring(0, progName.length() - 4);
        }
        try {
            PrivateDatabase db = this.testPrograms.get(progName);
            if (db != null) {
                ProgramDB program = this.openProgram(progName, db);
                this.openTestPrograms.add((Program)program);
                return program;
            }
            File dbDir = new File(TestProgramManager.getDbTestDir(), NamingUtilities.mangle((String)progName) + ".db");
            if ((db = this.loadDBFromDirectory(db, dbDir)) == null) {
                db = this.createNewDB(progName, db, dbDir);
            }
            if (db == null) {
                return null;
            }
            ProgramDB program = this.openProgram(progName, db);
            this.openTestPrograms.add((Program)program);
            return program;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load test program " + progName + " because: " + e.getMessage(), e);
        }
    }

    public Set<Program> getOpenPrograms() {
        return Collections.unmodifiableSet(this.openTestPrograms);
    }

    public void addOpenProgram(Program program) {
        this.openTestPrograms.add(program);
    }

    public void release(Program program) {
        ArrayList consumers = program.getConsumerList();
        if (consumers.contains(this)) {
            program.release((Object)this);
        }
        if (!program.isClosed()) {
            return;
        }
        this.openTestPrograms.remove(program);
    }

    public void saveToCache(String progName, ProgramDB program, boolean replace, TaskMonitor monitor) throws IOException, DuplicateNameException, CancelledException {
        if (progName.endsWith(".gzf")) {
            progName = progName.substring(0, progName.length() - 4);
        }
        if (this.testPrograms.containsKey(progName)) {
            if (!replace) {
                throw new DuplicateNameException(progName + " already cached");
            }
            this.testPrograms.remove(progName);
        }
        File dbDir = new File(TestProgramManager.getDbTestDir(), NamingUtilities.mangle((String)progName) + ".db");
        FileUtilities.deleteDir((File)dbDir);
        dbDir.mkdirs();
        DBHandle dbh = program.getDBHandle();
        LocalManagedBufferFile bfile = PrivateDatabase.createDatabase((File)dbDir, null, (int)dbh.getBufferSize());
        program.getDBHandle().saveAs((BufferFile)bfile, true, monitor);
        this.testPrograms.put(progName, new PrivateDatabase(dbDir));
        Msg.info((Object)this, (Object)("Stored unpacked program in TestEnv cache: " + progName));
    }

    public boolean isProgramCached(String name) {
        return this.testPrograms.containsKey(name);
    }

    public void removeFromProgramCache(String name) {
        this.testPrograms.remove(name);
        FileUtilities.deleteDir((File)this.getDbDir(name));
    }

    public void disposeOpenPrograms() {
        HashSet<Program> copy = new HashSet<Program>(this.openTestPrograms);
        for (Program program : copy) {
            this.release(program);
            if (!(program instanceof ProgramDB)) continue;
            ((DomainObjectAdapterDB)program).getDBHandle().close();
        }
    }

    public void markAllProgramsAsUnchanged() {
        for (Program program : this.openTestPrograms) {
            program.setTemporary(true);
        }
    }

    public void removeAllConsumersExcept(Program p, Object consumer) {
        p.getConsumerList().forEach(c -> {
            if (c != consumer) {
                p.release(c);
            }
        });
    }

    public DomainFile addProgramToProject(Project project, String programName) throws FileNotFoundException {
        DomainFolder rootFolder = project.getProjectData().getRootFolder();
        return this.addProgramToProject(rootFolder, programName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainFile addProgramToProject(DomainFolder folder, String programName) throws FileNotFoundException {
        File gzf = AbstractGenericTest.getTestDataFile((String)(programName + ".gzf"));
        Object name = gzf.getName();
        name = ((String)name).substring(0, ((String)name).indexOf("."));
        int oneUp = 0;
        while (true) {
            try {
                DomainFile df = folder.createFile((String)name, gzf, TaskMonitorAdapter.DUMMY_MONITOR);
                AbstractGenericTest.waitForPostedSwingRunnables();
                DomainObject dobj = df.getDomainObject((Object)this, true, false, null);
                try {
                    if (dobj.isChanged()) {
                        dobj.save("upgrade", null);
                    }
                }
                finally {
                    dobj.release((Object)this);
                }
                return df;
            }
            catch (VersionException e) {
                throw new RuntimeException("Program version is more recent than this code: " + programName);
            }
            catch (CancelledException e) {
                continue;
            }
            catch (InvalidNameException e) {
                throw new AssertException("Got invalid name exception: " + e);
            }
            catch (DuplicateFileException e) {
                name = (String)name + "_" + ++oneUp;
                continue;
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                throw new RuntimeException("Failed to restore test program: " + programName + " - " + msg);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgramDB openProgram(String progName, PrivateDatabase db) throws Exception {
        ProgramDB program = null;
        DBHandle dbh = null;
        boolean success = false;
        try {
            dbh = db.open(TaskMonitorAdapter.DUMMY_MONITOR);
            program = new ProgramDB(dbh, 1, null, (Object)this);
            success = true;
        }
        catch (VersionException ve) {
            if (!ve.isUpgradable()) {
                throw ve;
            }
            if (dbh != null) {
                dbh.close();
            }
            dbh = null;
            String message = System.getProperty("upgradeProgramErrorMessage");
            if (message == null) {
                message = "WARNING! Attempting data upgrade for ";
            }
            Msg.info((Object)this, (Object)(message + " '" + progName + "'"));
            long startTime = System.currentTimeMillis();
            this.upgradeDatabase(db);
            long endTime = System.currentTimeMillis();
            message = System.getProperty("upgradeTimeErrorMessage");
            if (message == null) {
                message = "Upgrade Time (ms): ";
            }
            Msg.info((Object)this, (Object)(message + (endTime - startTime)));
            dbh = db.open(TaskMonitorAdapter.DUMMY_MONITOR);
            program = new ProgramDB(dbh, 1, null, (Object)this);
            dbh = null;
            success = true;
        }
        finally {
            if (!success && dbh != null) {
                dbh.close();
            }
        }
        DomainFile df = program.getDomainFile();
        if (!df.isInWritableProject()) {
            df.setName(progName);
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateDatabase createNewDB(String programName, PrivateDatabase db, File dbDir) throws Exception {
        File gzf;
        if (db != null) {
            FileUtilities.deleteDir((File)dbDir);
        }
        if ((gzf = AbstractGenericTest.findTestDataFile((String)(programName + ".gzf"))) != null && gzf.exists()) {
            Msg.info((Object)this, (Object)("Unpacking: " + gzf));
            db = new PrivateDatabase(dbDir, gzf, TaskMonitorAdapter.DUMMY_MONITOR);
            this.testPrograms.put(programName, db);
            return db;
        }
        File xml = AbstractGenericTest.findTestDataFile((String)(programName + ".xml"));
        if (xml == null || !xml.exists()) {
            Msg.info((Object)this, (Object)("Test program not found: " + programName));
            return null;
        }
        Msg.info((Object)this, (Object)("Importing: " + xml));
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        ProgramXmlMgr mgr = new ProgramXmlMgr(xml);
        ProgramInfo info = mgr.getProgramInfo();
        Language language = null;
        try {
            language = languageService.getLanguage(info.languageID);
        }
        catch (LanguageNotFoundException e) {
            Processor processor = null;
            try {
                processor = Processor.toProcessor((String)info.processorName);
            }
            catch (ProcessorNotFoundException processorNotFoundException) {
                // empty catch block
            }
            language = languageService.getDefaultLanguage(processor);
        }
        CompilerSpec compilerSpec = null;
        if (info.compilerSpecID != null) {
            compilerSpec = language.getCompilerSpecByID(info.compilerSpecID);
        }
        if (compilerSpec == null) {
            compilerSpec = language.getDefaultCompilerSpec();
        }
        ConsoleTaskMonitor monitor = new ConsoleTaskMonitor();
        ProgramDB p = new ProgramDB(programName, language, compilerSpec, (Object)this);
        int txId = p.startTransaction("Import");
        try {
            mgr.read((Program)p, (TaskMonitor)monitor, new XmlProgramOptions(), MemoryConflictHandler.ALWAYS_OVERWRITE);
        }
        finally {
            p.endTransaction(txId, true);
        }
        DBHandle dbh = p.getDBHandle();
        LocalManagedBufferFile bfile = PrivateDatabase.createDatabase((File)dbDir, null, (int)dbh.getBufferSize());
        p.getDBHandle().saveAs((BufferFile)bfile, true, (TaskMonitor)monitor);
        p.release((Object)this);
        db = new PrivateDatabase(dbDir);
        Msg.info((Object)this, (Object)("Import of " + programName + " complete."));
        this.testPrograms.put(programName, db);
        return db;
    }

    private File getDbDir(String progName) {
        return new File(TestProgramManager.getDbTestDir(), NamingUtilities.mangle((String)progName) + ".db");
    }

    public static void setDbTestDir(File newDbTestDir) {
        Msg.debug(TestProgramManager.class, (Object)("Changing default db test directory to " + newDbTestDir));
        dbTestDir = newDbTestDir;
    }

    public static File getDbTestDir() {
        if (dbTestDir == null) {
            dbTestDir = TestProgramManager.getTestDBDirectory();
        }
        return dbTestDir;
    }

    private static File getTestDBDirectory() {
        String testDirPath = AbstractGTest.getTestDirectoryPath();
        File dir = new File(testDirPath, DB_DIR_NAME);
        dir.mkdir();
        return dir;
    }

    private PrivateDatabase loadDBFromDirectory(PrivateDatabase db, File dbDir) {
        if (!dbDir.isDirectory()) {
            return null;
        }
        try {
            db = new PrivateDatabase(dbDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (db == null || db.getCurrentVersion() == 0) {
            FileUtilities.deleteDir((File)dbDir);
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeDatabase(PrivateDatabase db) throws Exception {
        try (DBHandle dbh = db.openForUpdate(TaskMonitorAdapter.DUMMY_MONITOR);){
            ProgramDB program = new ProgramDB(dbh, 3, TaskMonitorAdapter.DUMMY_MONITOR, (Object)this);
            if (dbh != null) {
                dbh.save(null, null, TaskMonitorAdapter.DUMMY_MONITOR);
            }
            dbh = null;
            program.release((Object)this);
        }
    }
}

