/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingTool;
import docking.action.DockingActionIf;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.GhidraTestApplicationLayout;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPlugin;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GhidraApplicationConfiguration;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.listing.Program;
import ghidra.test.AbstractGhidraHeadlessIntegrationTest;
import ghidra.util.TaskUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import util.CollectionUtils;
import utility.application.ApplicationLayout;

public abstract class AbstractGhidraHeadedIntegrationTest
extends AbstractGhidraHeadlessIntegrationTest {
    public AbstractGhidraHeadedIntegrationTest() {
        AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)true);
    }

    @Override
    protected ApplicationLayout createApplicationLayout() {
        try {
            return new GhidraTestApplicationLayout(new File(AbstractGhidraHeadedIntegrationTest.getTestDirectoryPath()));
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    @Override
    protected ApplicationConfiguration createApplicationConfiguration() {
        GhidraApplicationConfiguration config = new GhidraApplicationConfiguration();
        config.setShowSplashScreen(false);
        return config;
    }

    public static void waitForProgram(Program program) {
        if (program != null) {
            program.flushEvents();
        }
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
    }

    public static <T extends Plugin> T addPlugin(PluginTool tool, Class<T> c) throws PluginException {
        tool.addPlugin(c.getName());
        return AbstractGhidraHeadedIntegrationTest.getPlugin(tool, c);
    }

    public static Plugin getPluginByName(PluginTool tool, String pluginName) {
        List list = tool.getManagedPlugins();
        for (Plugin p : list) {
            if (!pluginName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static DockingActionIf getAction(DockingTool tool, String owner, String name) {
        String fullName = name + " (" + owner + ")";
        List actions = tool.getDockingActionsByFullActionName(fullName);
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() > 1) {
            throw new AssertionFailedError("Found more than one action for name '" + fullName + "'");
        }
        return (DockingActionIf)CollectionUtils.any((Collection)actions);
    }

    public static DockingActionIf getAction(Plugin plugin, String actionName) {
        return AbstractGhidraHeadedIntegrationTest.getAction((DockingTool)plugin.getTool(), plugin.getName(), actionName);
    }

    public static DockingActionIf getLocalAction(ComponentProvider provider, String actionName) {
        return AbstractGhidraHeadedIntegrationTest.getAction(provider.getTool(), provider.getName(), actionName);
    }

    public static PluginTool showTool(PluginTool tool) {
        AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            boolean wasErrorGUIEnabled = AbstractGhidraHeadedIntegrationTest.isUseErrorGUI();
            AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)false);
            tool.setVisible(true);
            AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)wasErrorGUIEnabled);
        });
        AbstractGhidraHeadedIntegrationTest.waitForBusyTool(tool);
        return tool;
    }

    public static DialogComponentProvider showDialogWithoutBlocking(PluginTool tool, DialogComponentProvider provider) {
        AbstractGhidraHeadedIntegrationTest.executeOnSwingWithoutBlocking(() -> tool.showDialog(provider));
        DialogComponentProvider dialog = AbstractGhidraHeadedIntegrationTest.waitForDialogComponent(provider.getClass());
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
        return dialog;
    }

    public static void waitForBusyTool(PluginTool tool) {
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
        int timeout = PRIVATE_LONG_WAIT_TIMEOUT * 2;
        int totalTime = 0;
        while (tool.isExecutingCommand() || TaskUtilities.isExecutingTasks()) {
            if ((totalTime = (int)((long)totalTime + AbstractGhidraHeadedIntegrationTest.sleep((long)DEFAULT_WAIT_DELAY))) < timeout) continue;
            throw new AssertionFailedError("Timed-out waiting for tool to finish tasks");
        }
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
    }

    @Deprecated
    public static void waitForAnalysis() {
        Map programToManagersMap = (Map)AbstractGhidraHeadedIntegrationTest.getInstanceField((String)"managerMap", AutoAnalysisManager.class);
        Collection managers = programToManagersMap.values();
        for (AutoAnalysisManager manager : managers) {
            while (manager.isAnalyzing()) {
                AbstractGhidraHeadedIntegrationTest.sleep((long)DEFAULT_WAIT_DELAY);
            }
        }
    }

    public static PluginTool saveTool(Project project, PluginTool tool) {
        AtomicReference ref = new AtomicReference();
        AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            ToolChest toolChest = project.getLocalToolChest();
            ToolTemplate toolTemplate = tool.saveToolToToolTemplate();
            toolChest.replaceToolTemplate(toolTemplate);
            ToolManager toolManager = project.getToolManager();
            Workspace workspace = toolManager.getActiveWorkspace();
            tool.close();
            ref.set((PluginTool)workspace.runTool(toolTemplate));
        });
        return (PluginTool)ref.get();
    }

    public void click(CodeBrowserPlugin codeBrowser, int clickCount) {
        this.click(codeBrowser, clickCount, true);
    }

    public void click(CodeBrowserPlugin codeBrowser, int clickCount, boolean wait) {
        codeBrowser.updateNow();
        this.click(codeBrowser.getFieldPanel(), clickCount, wait);
        codeBrowser.updateNow();
    }

    protected void click(FieldPanel fp, int clickCount, boolean wait) {
        MouseEvent ev = new MouseEvent((Component)fp, 0, System.currentTimeMillis(), 0, 0, 0, clickCount, false, 1);
        AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            FieldLocation loc = fp.getCursorLocation();
            Field field = fp.getCurrentField();
            List listeners = (List)AbstractGhidraHeadedIntegrationTest.getInstanceField((String)"fieldMouseListeners", (Object)fp);
            for (FieldMouseListener l : listeners) {
                l.buttonPressed(loc, field, ev);
            }
        }, (boolean)wait);
    }
}

