/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramMemoryUtil;
import java.util.Arrays;

public class ProgramMemoryComparator {
    private Program program1;
    private Program program2;
    private AddressSet initInBoth;
    private AddressSet sameTypeInBoth;
    private AddressSet inBoth;
    private AddressSet onlyInOne;
    private AddressSet onlyInTwo;
    private AddressSet compatibleOnlyInTwo;

    public ProgramMemoryComparator(Program program1, Program program2) throws ProgramConflictException {
        this.program1 = program1;
        this.program2 = program2;
        if (program1 == null || program2 == null) {
            throw new IllegalArgumentException("program cannot be null.");
        }
        if (!ProgramMemoryComparator.similarPrograms(program1, program2)) {
            throw new ProgramConflictException("Address spaces conflict between " + program1.getName() + " and " + program2.getName() + ".\n");
        }
        this.determineAddressDiffs();
    }

    public static void compareAddressTypes(Program program1, Program program2) throws ProgramConflictException {
        AddressFactory af2;
        AddressFactory af1 = program1.getAddressFactory();
        if (!af1.equals((Object)(af2 = program2.getAddressFactory()))) {
            throw new ProgramConflictException("Address types conflict between " + program1.getName() + " and " + program2.getName() + ".\n");
        }
    }

    public static boolean similarPrograms(Program p1, Program p2) {
        Object[] spaces2;
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.getLanguageID().equals((Object)p2.getLanguageID())) {
            return true;
        }
        Object[] spaces1 = p1.getLanguage().getAddressFactory().getAddressSpaces();
        if (spaces1.length != (spaces2 = p2.getLanguage().getAddressFactory().getAddressSpaces()).length) {
            return false;
        }
        Arrays.sort(spaces1);
        Arrays.sort(spaces2);
        for (int i = 0; i < spaces1.length; ++i) {
            if (spaces1[i].equals(spaces2[i])) continue;
            return false;
        }
        return true;
    }

    private void determineAddressDiffs() {
        AddressSet initAddrSet1 = ProgramMemoryUtil.getAddressSet(this.program1, true);
        AddressSet uninitAddrSet1 = ProgramMemoryUtil.getAddressSet(this.program1, false);
        AddressSet initAddrSet2 = ProgramMemoryUtil.getAddressSet(this.program2, true);
        AddressSet uninitAddrSet2 = ProgramMemoryUtil.getAddressSet(this.program2, false);
        AddressSet initSet2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)initAddrSet2, this.program1);
        AddressSet uninitSet2CompatibleWith1 = DiffUtility.getCompatibleAddressSet((AddressSetView)uninitAddrSet2, this.program1);
        AddressSet uninitInBothCompatibleWith1 = uninitAddrSet1.intersect((AddressSetView)uninitSet2CompatibleWith1);
        this.initInBoth = initAddrSet1.intersect((AddressSetView)initSet2CompatibleWith1);
        this.sameTypeInBoth = new AddressSet((AddressSetView)this.initInBoth);
        this.sameTypeInBoth.add((AddressSetView)uninitInBothCompatibleWith1);
        AddressSetView addrSet1 = ProgramMemoryUtil.getAddressSet(this.program1);
        AddressSetView addrSet2 = ProgramMemoryUtil.getAddressSet(this.program2);
        AddressSet addrSet2CompatibleWith1 = DiffUtility.getCompatibleAddressSet(addrSet2, this.program1);
        this.inBoth = addrSet1.intersect((AddressSetView)addrSet2CompatibleWith1);
        this.onlyInOne = addrSet1.xor((AddressSetView)this.inBoth);
        AddressSet inBothCompatibleWith2 = DiffUtility.getCompatibleAddressSet((AddressSetView)this.inBoth, this.program2);
        this.onlyInTwo = addrSet2.xor((AddressSetView)inBothCompatibleWith2);
        this.compatibleOnlyInTwo = DiffUtility.getCompatibleAddressSet((AddressSetView)this.onlyInTwo, this.program1);
    }

    public Program getProgramOne() {
        return this.program1;
    }

    public Program getProgramTwo() {
        return this.program2;
    }

    public static AddressSet getCombinedAddresses(Program program1, Program program2) {
        AddressSetView addrSet1 = ProgramMemoryUtil.getAddressSet(program1);
        AddressSetView addrSet2 = ProgramMemoryUtil.getAddressSet(program2);
        AddressSet addrSet2CompatibleWith1 = DiffUtility.getCompatibleAddressSet(addrSet2, program1);
        return addrSet1.union((AddressSetView)addrSet2CompatibleWith1);
    }

    public AddressRangeIterator getAddressRanges() {
        return ProgramMemoryComparator.getCombinedAddresses(this.program1, this.program2).getAddressRanges();
    }

    public AddressSet getAddressesInCommon() {
        return new AddressSet((AddressSetView)this.inBoth);
    }

    public AddressSet getInitializedAddressesInCommon() {
        return new AddressSet((AddressSetView)this.initInBoth);
    }

    public AddressSet getSameMemTypeAddressesInCommon() {
        return new AddressSet((AddressSetView)this.sameTypeInBoth);
    }

    public AddressSet getAddressesOnlyInOne() {
        return new AddressSet((AddressSetView)this.onlyInOne);
    }

    public AddressSet getAddressesOnlyInTwo() {
        return new AddressSet((AddressSetView)this.onlyInTwo);
    }

    public AddressSet getCompatibleAddressesOnlyInTwo() {
        return new AddressSet((AddressSetView)this.compatibleOnlyInTwo);
    }

    public boolean hasMemoryDifferences() {
        return !this.onlyInOne.isEmpty() || !this.onlyInTwo.isEmpty();
    }

    public static boolean sameProgramContextRegisterNames(Program program1, Program program2) {
        ProgramContext pc1 = program1.getProgramContext();
        ProgramContext pc2 = program2.getProgramContext();
        Object[] names1 = pc1.getRegisterNames();
        Object[] names2 = pc2.getRegisterNames();
        Arrays.sort(names1);
        Arrays.sort(names2);
        return Arrays.equals(names1, names2);
    }
}

