/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.GoToService;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Playable;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.table.IncomingReferencesTableModel;
import ghidra.util.table.field.OutgoingReferenceEndpoint;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class OperandFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{OperandFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable navigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        int[] componentPath;
        if (mouseEvent.getButton() != 1) {
            return false;
        }
        OperandFieldLocation operandLocation = (OperandFieldLocation)location;
        if (mouseEvent.getClickCount() == 1) {
            return this.handleSingleClick(mouseEvent, navigatable, operandLocation);
        }
        if (mouseEvent.getClickCount() != 2) {
            return false;
        }
        Program program = navigatable.getProgram();
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(operandLocation.getAddress());
        if (codeUnit instanceof Data && (componentPath = operandLocation.getComponentPath()) != null && componentPath.length > 0) {
            Data d = (Data)codeUnit;
            codeUnit = d.getComponent(componentPath);
        }
        if (codeUnit == null) {
            return false;
        }
        return this.checkOperandFieldLocation(navigatable, codeUnit, operandLocation, serviceProvider);
    }

    private boolean handleSingleClick(MouseEvent mouseEvent, Navigatable navigatable, OperandFieldLocation location) {
        Data data;
        Object value;
        Program program = navigatable.getProgram();
        OperandFieldLocation operandLocation = location;
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(operandLocation.getAddress());
        if (codeUnit instanceof Data && (value = (data = (Data)codeUnit).getValue()) instanceof Playable) {
            ((Playable)value).clicked(mouseEvent);
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }

    private boolean checkOperandFieldLocation(Navigatable navigatable, CodeUnit codeUnit, OperandFieldLocation loc, ServiceProvider serviceProvider) {
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        int opIndex = loc.getOperandIndex();
        if (this.checkVariableReference(navigatable, codeUnit, loc, goToService) || this.checkExternalReference(navigatable, codeUnit, loc, goToService) || this.checkMemRefs(navigatable, codeUnit, loc, serviceProvider)) {
            return true;
        }
        return this.checkOpObject(navigatable, codeUnit, opIndex, loc.getSubOperandIndex(), goToService);
    }

    private boolean checkExternalReference(Navigatable navigatable, CodeUnit codeUnit, OperandFieldLocation loc, GoToService goToService) {
        Address refAddr = loc.getRefAddress();
        if (refAddr == null || !refAddr.isExternalAddress()) {
            return false;
        }
        Program program = codeUnit.getProgram();
        Symbol s = program.getSymbolTable().getPrimarySymbol(refAddr);
        if (s == null) {
            return false;
        }
        ExternalLocation extLoc = program.getExternalManager().getExternalLocation(s);
        return goToService.goToExternalLocation(extLoc, true);
    }

    private boolean checkVariableReference(Navigatable navigatable, CodeUnit codeUnit, OperandFieldLocation loc, GoToService goToService) {
        Variable variable;
        Register reg;
        Variable variable2;
        if (!(codeUnit instanceof Instruction)) {
            return false;
        }
        VariableOffset variableOffset = loc.getVariableOffset();
        if (variableOffset != null && (variable2 = variableOffset.getVariable()) != null) {
            goToService.goTo(navigatable, (ProgramLocation)new VariableNameFieldLocation(navigatable.getProgram(), variable2, 0), navigatable.getProgram());
            return true;
        }
        Program p = codeUnit.getProgram();
        Address cuAddr = codeUnit.getMinAddress();
        Address refAddr = loc.getRefAddress();
        Function func = p.getFunctionManager().getFunctionContaining(cuAddr);
        if (func == null) {
            return false;
        }
        VariableNameFieldLocation varLoc = null;
        if (refAddr != null && !refAddr.isStackAddress() && (reg = p.getRegister(refAddr, 1)) != null && (variable = p.getFunctionManager().getReferencedVariable(cuAddr, refAddr, reg.getMinimumByteSize(), !this.isWrite((Instruction)codeUnit, loc.getOperandIndex(), reg))) != null) {
            varLoc = new VariableNameFieldLocation(navigatable.getProgram(), variable, 0);
        }
        if (varLoc != null) {
            goToService.goTo(navigatable, (ProgramLocation)varLoc, navigatable.getProgram());
            return true;
        }
        Reference reference = codeUnit.getPrimaryReference(loc.getOperandIndex());
        if (reference == null) {
            return false;
        }
        variable = p.getFunctionManager().getReferencedVariable(cuAddr, reference.getToAddress(), 0, reference.getReferenceType().isRead());
        if (variable != null) {
            varLoc = new VariableNameFieldLocation(navigatable.getProgram(), variable, 0);
            goToService.goTo(navigatable, (ProgramLocation)varLoc, navigatable.getProgram());
            return true;
        }
        if (reference.isStackReference()) {
            FunctionSignatureFieldLocation fnLoc = new FunctionSignatureFieldLocation(p, func.getEntryPoint(), null, 0, func.getPrototypeString(false, false));
            goToService.goTo(navigatable, (ProgramLocation)fnLoc, navigatable.getProgram());
            return true;
        }
        return false;
    }

    private boolean isWrite(Instruction inst, int operandIndex, Register reg) {
        for (Object obj : inst.getResultObjects()) {
            if (obj != reg) continue;
            return true;
        }
        return false;
    }

    private boolean checkMemRefs(Navigatable navigatable, CodeUnit codeUnit, OperandFieldLocation loc, ServiceProvider serviceProvider) {
        Address refAddr = loc.getRefAddress();
        if (refAddr == null || !refAddr.isMemoryAddress()) {
            return false;
        }
        int opIndex = loc.getOperandIndex();
        Reference[] refs = codeUnit.getOperandReferences(loc.getOperandIndex());
        Address[] addrs = this.getAddressesForReferences(refs, codeUnit, serviceProvider);
        if (addrs.length == 0) {
            return false;
        }
        if (addrs.length > 1) {
            ArrayList<OutgoingReferenceEndpoint> outgoingReferences = new ArrayList<OutgoingReferenceEndpoint>();
            for (int i = 0; i < refs.length; ++i) {
                Reference ref = refs[i];
                boolean offcut = ReferenceUtils.isOffcut(codeUnit.getProgram(), ref.getToAddress());
                outgoingReferences.add(new OutgoingReferenceEndpoint(ref, addrs[i], offcut));
            }
            IncomingReferencesTableModel model = new IncomingReferencesTableModel("Operand", serviceProvider, codeUnit.getProgram(), outgoingReferences, null);
            TableService service = (TableService)serviceProvider.getService(TableService.class);
            Navigatable nav = NavigationUtils.getActiveNavigatable();
            String addressString = codeUnit.getMinAddress().toString();
            service.showTable("Operand References for " + addressString, "Operands", model, "References", nav);
            return true;
        }
        Address gotoAddr = null;
        if (addrs.length == 1) {
            gotoAddr = addrs[0];
        } else {
            Scalar scalar;
            gotoAddr = codeUnit.getAddress(opIndex);
            if (gotoAddr == null && (scalar = codeUnit.getScalar(opIndex)) != null) {
                Address minAddress = codeUnit.getMinAddress();
                try {
                    gotoAddr = minAddress.getNewAddress(scalar.getUnsignedValue(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (gotoAddr == null) {
            return false;
        }
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        return goToService.goTo(navigatable, codeUnit.getProgram(), gotoAddr, codeUnit.getAddress());
    }

    private Address[] getAddressesForReferences(Reference[] references, CodeUnit codeUnit, ServiceProvider serviceProvider) {
        Address[] addresses = new Address[references.length];
        for (int i = 0; i < references.length; ++i) {
            addresses[i] = this.getAddressForReference(codeUnit, references[i], serviceProvider, references.length != 1);
        }
        return addresses;
    }

    private Address getAddressForReference(CodeUnit codeUnit, Reference reference, ServiceProvider serviceProvider, boolean skipExternal) {
        Address address = reference.getToAddress();
        RefType refType = reference.getReferenceType();
        if (refType.isIndirect()) {
            Program program = codeUnit.getProgram();
            Data data = program.getListing().getDefinedDataAt(address);
            Address indirectAddrress = null;
            if (data != null) {
                if (data.isPointer()) {
                    Reference ref = data.getPrimaryReference(0);
                    indirectAddrress = ref != null ? ref.getToAddress() : (Address)data.getValue();
                }
            } else {
                PseudoDisassembler pdis = new PseudoDisassembler(program);
                indirectAddrress = pdis.getIndirectAddr(address);
            }
            if (!(indirectAddrress == null || indirectAddrress.isExternalAddress() && skipExternal || !this.followIndirectReference(serviceProvider, indirectAddrress, program))) {
                return indirectAddrress;
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean followIndirectReference(ServiceProvider serviceProvider, Address indirectAddrress, Program program) {
        OptionsService optionsService = (OptionsService)serviceProvider.getService(OptionsService.class);
        if (optionsService == null) {
            return false;
        }
        NavigationOptions navOptions = new NavigationOptions(optionsService);
        try {
            if (!navOptions.isFollowIndirectionEnabled()) {
                boolean bl = false;
                return bl;
            }
            if (indirectAddrress.isExternalAddress()) {
                boolean bl = navOptions.isGotoExternalProgramEnabled();
                return bl;
            }
            boolean bl = program.getMemory().contains(indirectAddrress);
            return bl;
        }
        finally {
            navOptions.dispose();
        }
    }

    private boolean checkOpObject(Navigatable navigatable, CodeUnit codeUnit, int opIndex, int subOpIndex, GoToService goToService) {
        if (codeUnit instanceof Data) {
            return this.handleData((Data)codeUnit, navigatable, goToService);
        }
        if (!(codeUnit instanceof Instruction) || subOpIndex < 0) {
            return false;
        }
        List opObjects = ((Instruction)codeUnit).getDefaultOperandRepresentationList(opIndex);
        if (opObjects == null || opObjects.size() <= subOpIndex) {
            return false;
        }
        Address goToAddr = this.getAddressForOpObject(opObjects.get(subOpIndex), codeUnit);
        return goToAddr != null && goToService.goTo(navigatable, goToAddr);
    }

    private boolean handleData(Data data, Navigatable navigatable, GoToService goToService) {
        Object value = data.getValue();
        Address address = null;
        if (value instanceof Address) {
            address = (Address)value;
        } else if (value instanceof Scalar) {
            Scalar scalar = (Scalar)value;
            address = this.getAddressFromScalar((CodeUnit)data, scalar);
        }
        if (address == null) {
            return false;
        }
        return goToService.goTo(navigatable, address);
    }

    private Address getAddressForOpObject(Object opObject, CodeUnit codeUnit) {
        if (opObject instanceof Address) {
            return (Address)opObject;
        }
        if (opObject instanceof Scalar) {
            Scalar scalar = (Scalar)opObject;
            return this.getAddressFromScalar(codeUnit, scalar);
        }
        return null;
    }

    private Address getAddressFromScalar(CodeUnit codeUnit, Scalar scalar) {
        Address minAddress = codeUnit.getMinAddress();
        Address address = null;
        try {
            address = minAddress.getNewAddress(scalar.getUnsignedValue(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Program program = codeUnit.getProgram();
        if (address == null || !program.getMemory().contains(address)) {
            AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
            try {
                address = space.getAddress(scalar.getUnsignedValue(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return address;
    }
}

