/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.data.Array;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.util.FieldNameFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class FieldNameFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Field Name";
    private static final String GROUP_TITLE = "Field Name";
    public static final String ARRAY_INDEX_FORMAT_MSG = "Field Name.Array Index Format";
    private IndexFormat format;

    public FieldNameFieldFactory() {
        super("Field Name");
    }

    private FieldNameFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, ToolOptions fieldOptions) {
        super("Field Name", model, hlProvider, displayOptions, (Options)fieldOptions);
        fieldOptions.registerOption(ARRAY_INDEX_FORMAT_MSG, (Object)IndexFormat.decimal, null, "Hex or Decimal field offsets");
        this.format = (IndexFormat)fieldOptions.getEnum(ARRAY_INDEX_FORMAT_MSG, (Enum)IndexFormat.decimal);
    }

    private String getFieldName(Data data) {
        Data parent = data.getParent();
        if (parent != null && parent.getDataType() instanceof Array) {
            String indexStr = this.format.prefix + Integer.toString(data.getComponentIndex(), this.format.radix) + this.format.postfix;
            return "[" + indexStr + "]";
        }
        return data.getFieldName();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (options.getName().equals("Listing Fields") && optionName.equals(ARRAY_INDEX_FORMAT_MSG)) {
            this.format = (IndexFormat)((Object)newValue);
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Data)) {
            return null;
        }
        Data data = (Data)obj;
        String fieldName = this.getFieldName(data);
        if (fieldName == null || fieldName.length() == 0) {
            return null;
        }
        AttributedString as = new AttributedString(fieldName, this.color, this.getMetrics());
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Data)) {
            return null;
        }
        Data data = (Data)obj;
        return new FieldNameFieldLocation(data.getProgram(), data.getMinAddress(), data.getComponentPath(), this.getFieldName(data), col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof FieldNameFieldLocation)) {
            return null;
        }
        FieldNameFieldLocation loc = (FieldNameFieldLocation)programLoc;
        if (!this.hasSamePath(bf, (ProgramLocation)loc)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, 0, loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 5 || category == 6;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new FieldNameFieldFactory(formatModel, provider, (Options)displayOptions, fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.FIELD_NAME.getDefaultColor();
    }

    public static enum IndexFormat {
        decimal(10, "", ""),
        hex(16, "0x", ""),
        octal(8, "0", ""),
        binary(2, "", "b");

        final int radix;
        final String prefix;
        final String postfix;

        private IndexFormat(int radix, String prefix, String postfix) {
            this.radix = radix;
            this.prefix = prefix;
            this.postfix = postfix;
        }
    }
}

