/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PeDataType
extends FactoryStructureDataType {
    private static final long serialVersionUID = 1L;

    public PeDataType() {
        this(null);
    }

    public PeDataType(DataTypeManager dtm) {
        super("PE", dtm);
    }

    public String getMnemonic(Settings settings) {
        return "PE";
    }

    public String getDescription() {
        return "Windows Portable Executable Data Type";
    }

    public boolean isDynamicallySized() {
        return true;
    }

    protected void populateDynamicStructure(MemBuffer buf, Structure struct) {
        try {
            SectionHeader[] sections;
            Memory memory = buf.getMemory();
            MemoryBlock block = memory.getBlock(buf.getAddress());
            int size = Math.min(0x100000, (int)block.getEnd().subtract(buf.getAddress()) + 1);
            byte[] bytes = new byte[size];
            block.getBytes(buf.getAddress(), bytes);
            ByteArrayProvider bap = new ByteArrayProvider(bytes);
            PortableExecutable pe = PortableExecutable.createPortableExecutable((GenericFactory)RethrowContinuesFactory.INSTANCE, bap, PortableExecutable.SectionLayout.FILE);
            DOSHeader dosHeader = pe.getDOSHeader();
            this.addComponent(struct, dosHeader.toDataType(), "IMAGE_DOS_HEADER");
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                return;
            }
            this.addComponent(struct, ntHeader.toDataType(), "IMAGE_NT_HEADERS32");
            for (SectionHeader section : sections = ntHeader.getFileHeader().getSectionHeaders()) {
                this.addComponent(struct, section.toDataType(), section.getReadableName());
            }
        }
        catch (IOException iOException) {
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    public DataType clone(DataTypeManager dtm) {
        return new PeDataType(dtm);
    }
}

