/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssembly
extends CliAbstractTable {
    public CliTableAssembly(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        StructureDataType rowDt = (StructureDataType)this.toDataType();
        for (int i = 0; i < this.numRows; ++i) {
            reader.setPointerIndex(this.readerOffset + (long)(rowDt.getLength() * i));
            CliAssemblyRow row = new CliAssemblyRow(reader.readNextInt(), reader.readNextShort(), reader.readNextShort(), reader.readNextShort(), reader.readNextShort(), reader.readNextInt(), this.readBlobIndex(reader), this.readStringIndex(reader), this.readStringIndex(reader));
            this.rows.add(row);
            this.blobs.add(row.publicKeyIndex);
            this.strings.add(row.nameIndex);
            this.strings.add(row.cultureIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public DataType getRowDataType() {
        return this.toDataType();
    }

    @Override
    public DataType toDataType() {
        StructureDataType table = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Assembly Table", 0);
        table.add((DataType)CliFlags.CliEnumAssemblyHashAlgorithm.dataType, "HashAlg", "Type of hash present");
        table.add(WORD, "MajorVersion", null);
        table.add(WORD, "MinorVersion", null);
        table.add(WORD, "BuildNumber", null);
        table.add(WORD, "RevisionNumber", null);
        table.add((DataType)CliFlags.CliEnumAssemblyFlags.dataType, "Flags", "Bitmask of type AssemblyFlags");
        table.add(this.metadataStream.getBlobIndexDataType(), "PublicKey", "index into Blob heap");
        table.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        table.add(this.metadataStream.getStringIndexDataType(), "Culture", "index into String heap");
        return table;
    }

    public class CliAssemblyRow
    extends CliAbstractTableRow {
        public int hashAlg;
        public short majorVersion;
        public short minorVersion;
        public short buildNumber;
        public short revisionNumber;
        public int flags;
        public int publicKeyIndex;
        public int nameIndex;
        public int cultureIndex;

        public CliAssemblyRow(int hashAlg, short majorVersion, short minorVersion, short buildNumber, short revisionNumber, int flags, int publicKeyIndex, int nameIndex, int cultureIndex) {
            this.hashAlg = hashAlg;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.buildNumber = buildNumber;
            this.revisionNumber = revisionNumber;
            this.flags = flags;
            this.publicKeyIndex = publicKeyIndex;
            this.nameIndex = nameIndex;
            this.cultureIndex = cultureIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("%s v%d.%d build%d rev%d pubkey index %x culture index %x flags %s", CliTableAssembly.this.metadataStream.getStringsStream().getString(this.nameIndex), this.majorVersion, this.minorVersion, this.buildNumber, this.revisionNumber, this.publicKeyIndex, this.cultureIndex, CliFlags.CliEnumAssemblyFlags.dataType.getName(this.flags & 0xFFFFFFFF));
        }
    }
}

