/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import java.io.IOException;
import java.util.ArrayList;

public class OmfFixupRecord
extends OmfRecord {
    private Subrecord[] subrecs;
    private OmfEnumeratedData lastLEData = null;
    private OmfIteratedData lastLIData = null;

    public OmfFixupRecord(BinaryReader reader) throws IOException {
        ArrayList<ThreadSubrecord> subreclist = new ArrayList<ThreadSubrecord>();
        boolean hasBigFields = (this.getRecordType() & 1) != 0;
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (reader.getPointerIndex() < max) {
            Subrecord subrec;
            byte peek = reader.peekNextByte();
            if ((peek & 0x80) == 0) {
                subrec = ThreadSubrecord.readThreadSubrecord(reader, hasBigFields);
                subreclist.add((ThreadSubrecord)subrec);
                continue;
            }
            subrec = FixupSubrecord.readFixupSubrecord(reader, hasBigFields);
            subreclist.add((ThreadSubrecord)subrec);
        }
        this.subrecs = new Subrecord[subreclist.size()];
        subreclist.toArray(this.subrecs);
        this.readCheckSumByte(reader);
    }

    public void setDataBlock(Object last) {
        if (last instanceof OmfEnumeratedData) {
            this.lastLEData = (OmfEnumeratedData)last;
            this.lastLIData = null;
        } else {
            this.lastLIData = (OmfIteratedData)last;
            this.lastLEData = null;
        }
    }

    public Subrecord[] getSubrecords() {
        return this.subrecs;
    }

    public static class FixupSubrecord
    extends Subrecord {
        private byte lobyte;
        private byte hibyte;
        private FixupTarget target;

        public FixupSubrecord() {
            super(false);
        }

        public void resolveFixup(FixupState state) throws OmfException {
            int segIndex;
            long blockDisplace;
            this.target.resolveTarget(state);
            this.target.resolveFrame(state);
            state.M = (this.lobyte >> 6 & 1) != 0;
            state.locationType = this.lobyte >> 2 & 0xF;
            int dataRecordOffset = this.lobyte & 3;
            dataRecordOffset <<= 8;
            dataRecordOffset |= this.hibyte & 0xFF;
            if (state.currentFixupRecord.lastLEData != null) {
                blockDisplace = state.currentFixupRecord.lastLEData.getDataOffset();
                segIndex = state.currentFixupRecord.lastLEData.getSegmentIndex();
            } else {
                blockDisplace = state.currentFixupRecord.lastLIData.getDataOffset();
                segIndex = state.currentFixupRecord.lastLIData.getSegmentIndex();
            }
            OmfSegmentHeader seg = state.header.resolveSegment(segIndex);
            state.locAddress = seg.getAddress(state.language).add(blockDisplace + (long)dataRecordOffset);
        }

        public static FixupSubrecord readFixupSubrecord(BinaryReader reader, boolean hasBigFields) throws IOException {
            FixupSubrecord fixupSubrecord = new FixupSubrecord();
            fixupSubrecord.lobyte = reader.readNextByte();
            fixupSubrecord.hibyte = reader.readNextByte();
            fixupSubrecord.target = FixupTarget.readFixupTarget(reader, hasBigFields);
            return fixupSubrecord;
        }
    }

    public static class FixupTarget {
        private byte fixData;
        private int frameDatum;
        private int targetDatum;
        private int targetDisplacement;

        public boolean isFrameThread() {
            return (this.fixData >> 7 & 1) != 0;
        }

        public boolean isTargetThread() {
            return (this.fixData >> 3 & 1) != 0;
        }

        public int getFrameMethod() {
            return this.fixData >> 4 & 7;
        }

        public int getP() {
            int res = this.fixData >> 2 & 1;
            return res;
        }

        public void resolveFrame(FixupState state) throws OmfException {
            int index;
            int method;
            if (this.isFrameThread()) {
                int threadnum = this.fixData >> 4 & 3;
                ThreadSubrecord subrec = state.frameThreads[threadnum];
                method = subrec.getMethod();
                index = subrec.getIndex();
            } else {
                method = this.getFrameMethod();
                index = this.frameDatum;
            }
            switch (method) {
                case 0: {
                    state.frameState = state.header.resolveSegment(index).getFrameDatum();
                    break;
                }
                case 1: {
                    state.frameState = state.groups.get(index - 1).getFrameDatum();
                    break;
                }
                case 2: {
                    state.frameState = state.externals.get(index - 1).getFrameDatum();
                    break;
                }
                case 4: {
                    index = state.currentFixupRecord.lastLEData != null ? state.currentFixupRecord.lastLEData.getSegmentIndex() : state.currentFixupRecord.lastLIData.getSegmentIndex();
                    state.frameState = state.header.resolveSegment(index).getFrameDatum();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    state.frameState = -1;
                }
            }
        }

        public void resolveTarget(FixupState state) throws OmfException {
            int index;
            int method;
            if (this.isTargetThread()) {
                int threadnum = this.fixData & 3;
                ThreadSubrecord subrec = state.targetThreads[threadnum];
                method = this.getP();
                method <<= 2;
                method |= subrec.getMethod();
                index = subrec.getIndex();
            } else {
                method = this.fixData & 7;
                index = this.targetDatum;
            }
            switch (method) {
                case 0: {
                    state.targetState = state.header.resolveSegment(index).getStartAddress();
                    state.targetState += (long)this.targetDisplacement;
                    break;
                }
                case 1: {
                    state.targetState = state.groups.get(index - 1).getStartAddress();
                    state.targetState += (long)this.targetDisplacement;
                    break;
                }
                case 2: {
                    state.targetState = state.externals.get(index - 1).getAddress().getOffset();
                    state.targetState += (long)this.targetDisplacement;
                    break;
                }
                case 4: {
                    state.targetState = state.header.resolveSegment(index).getStartAddress();
                    break;
                }
                case 5: {
                    state.targetState = state.groups.get(index - 1).getStartAddress();
                    break;
                }
                case 6: {
                    state.targetState = state.externals.get(index - 1).getAddress().getOffset();
                    break;
                }
                default: {
                    state.targetState = -1L;
                }
            }
        }

        public static FixupTarget readFixupTarget(BinaryReader reader, boolean hasBigFields) throws IOException {
            int method;
            FixupTarget fixupTarget = new FixupTarget();
            fixupTarget.fixData = reader.readNextByte();
            if ((fixupTarget.fixData & 0x80) == 0 && (method = fixupTarget.fixData >> 4 & 7) < 3) {
                fixupTarget.frameDatum = OmfRecord.readIndex(reader);
            }
            if ((fixupTarget.fixData & 8) == 0) {
                fixupTarget.targetDatum = OmfRecord.readIndex(reader);
            }
            if ((fixupTarget.fixData & 4) == 0) {
                fixupTarget.targetDisplacement = OmfRecord.readInt2Or4(reader, hasBigFields);
            }
            return fixupTarget;
        }
    }

    public static class ThreadSubrecord
    extends Subrecord {
        private byte type;
        private int index;

        public ThreadSubrecord() {
            super(true);
        }

        public int getMethod() {
            return this.type >> 2 & 7;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isFrameThread() {
            return (this.type >> 6 & 1) != 0;
        }

        public int getThreadNum() {
            return this.type & 3;
        }

        public void updateState(FixupState state) {
            if (this.isFrameThread()) {
                state.frameThreads[this.getThreadNum()] = this;
            } else {
                state.targetThreads[this.getThreadNum()] = this;
            }
        }

        public static ThreadSubrecord readThreadSubrecord(BinaryReader reader, boolean hasBigFields) throws IOException {
            ThreadSubrecord thread = new ThreadSubrecord();
            thread.type = reader.readNextByte();
            int method = thread.getMethod();
            thread.index = method < 4 ? OmfRecord.readInt1Or2(reader, hasBigFields) : -1;
            return thread;
        }
    }

    public static class Subrecord {
        private boolean isThread;

        public Subrecord(boolean isthread) {
            this.isThread = isthread;
        }

        public boolean isThread() {
            return this.isThread;
        }
    }

    public static class FixupState {
        public Language language;
        OmfFileHeader header;
        public ThreadSubrecord[] frameThreads = new ThreadSubrecord[4];
        public ThreadSubrecord[] targetThreads = new ThreadSubrecord[4];
        public OmfFixupRecord currentFixupRecord;
        public ArrayList<OmfGroupRecord> groups;
        public ArrayList<OmfSymbol> externals;
        public int frameState;
        public long targetState;
        public Address locAddress;
        public boolean M;
        public int locationType;

        public FixupState(OmfFileHeader header, ArrayList<OmfSymbol> externsyms, Language lang) {
            for (int i = 0; i < 4; ++i) {
                this.frameThreads[i] = null;
                this.targetThreads[i] = null;
            }
            this.header = header;
            this.groups = header.getGroups();
            this.externals = externsyms;
            this.language = lang;
        }

        public void clear() {
            this.targetState = -1L;
            this.locAddress = null;
            this.locationType = -1;
        }
    }
}

