/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.plugin.importer.NewLanguagePanel;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.util.SystemUtilities;

public class SelectLanguageDialog
extends DialogComponentProvider {
    private NewLanguagePanel languagePanel = new NewLanguagePanel();
    private boolean actionComplete = false;
    private LanguageCompilerSpecPair selectedLcsPair;
    private boolean wasCancelled = false;

    public SelectLanguageDialog(String title, String approveButtonText) {
        super(title, true);
        this.addWorkPanel(this.languagePanel);
        this.addOKButton();
        this.addCancelButton();
        this.setOkButtonText(approveButtonText);
        this.setDefaultButton(this.okButton);
    }

    protected void okCallback() {
        if (this.checkInput()) {
            this.actionComplete = true;
            this.close();
        }
    }

    public void close() {
        super.close();
        this.languagePanel.dispose();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.wasCancelled = true;
    }

    boolean wasCancelled() {
        return this.wasCancelled;
    }

    private boolean checkInput() {
        return this.languagePanel.getSelectedLcsPair() != null;
    }

    void setSelectedLanguage(LanguageCompilerSpecPair language) {
        SystemUtilities.runSwingNow(() -> this.languagePanel.setSelectedLcsPair(language));
    }

    public LanguageCompilerSpecPair getSelectedLanguage() {
        SystemUtilities.runSwingNow(() -> this.doSelect());
        return this.selectedLcsPair;
    }

    private void doSelect() {
        this.selectedLcsPair = null;
        this.actionComplete = false;
        DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
        if (this.actionComplete) {
            this.selectedLcsPair = this.languagePanel.getSelectedLcsPair();
        }
    }
}

