/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.plugin.exceptionhandlers.gcc.datatype.SignedLeb128DataType;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.UnsignedLeb128DataType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;

public class GccAnalysisUtils {
    public static byte readByte(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getByte(addr);
    }

    public static int readWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getShort(addr);
    }

    public static long readDWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getInt(addr);
    }

    public static long readQWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getLong(addr);
    }

    public static void readBytes(Program program, Address addr, byte[] buffer) throws MemoryAccessException {
        program.getMemory().getBytes(addr, buffer);
    }

    public static long readULEB128(Program program, Address addr) {
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        Scalar scalar = (Scalar)uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), uleb.getLength((MemBuffer)buf, -1));
        return scalar.getUnsignedValue();
    }

    public static int getULEB128Length(Program program, Address addr) {
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        return uleb.getLength((MemBuffer)buf, -1);
    }

    public static long readSLEB128(Program program, Address addr) {
        SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        Scalar scalar = (Scalar)sleb.getValue((MemBuffer)buf, sleb.getDefaultSettings(), sleb.getLength((MemBuffer)buf, -1));
        return scalar.getUnsignedValue();
    }

    public static int getSLEB128Length(Program program, Address addr) {
        SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        return sleb.getLength((MemBuffer)buf, -1);
    }
}

