/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.widgets.DropDownSelectionTextField;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.program.model.data.DataType;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class ParameterDataTypeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private DataTypeSelectionEditor editor;
    private JLabel label = new JLabel();
    private DropDownSelectionTextField<DataType> textField;
    private JButton dataTypeChooserButton;
    private DataType dt;
    private JPanel editorPanel;
    private DataTypeManagerService service;
    private DialogComponentProvider dialog;

    ParameterDataTypeCellEditor(DialogComponentProvider dialog, DataTypeManagerService service) {
        this.dialog = dialog;
        this.service = service;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setBorder(BorderFactory.createBevelBorder(1));
        }
        this.init();
        this.dt = (DataType)value;
        this.editor.setCellEditorValue(this.dt);
        return this.editorPanel;
    }

    private void init() {
        this.editor = new DataTypeSelectionEditor(this.service, -1, DataTypeParser.AllowedDataTypes.ALL);
        this.editor.setTabCommitsEdit(true);
        this.editor.setConsumeEnterKeyPress(false);
        this.textField = this.editor.getDropDownTextField();
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.cancelCellEditing();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                ParameterDataTypeCellEditor.this.stopCellEditing();
            }
        });
        this.dataTypeChooserButton = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = 15;
                return preferredSize;
            }
        };
        this.dataTypeChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataType dataType = ParameterDataTypeCellEditor.this.service.getDataType((String)null);
                        if (dataType != null) {
                            ParameterDataTypeCellEditor.this.editor.setCellEditorValue(dataType);
                            ParameterDataTypeCellEditor.this.editor.stopCellEditing();
                        } else {
                            ParameterDataTypeCellEditor.this.editor.cancelCellEditing();
                        }
                    }
                });
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ParameterDataTypeCellEditor.this.textField.selectAll();
                ParameterDataTypeCellEditor.this.textField.removeFocusListener((FocusListener)this);
            }
        };
        this.textField.addFocusListener((FocusListener)focusListener);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add((Component)this.textField, "Center");
        this.editorPanel.add((Component)this.dataTypeChooserButton, "East");
    }

    public DropDownSelectionTextField<DataType> getTextField() {
        return this.textField;
    }

    public JButton getChooserButton() {
        return this.dataTypeChooserButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.dt;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            DataType dataType = this.editor.getCellEditorValueAsDataType();
            this.dialog.clearStatusText();
            if (dataType == null) {
                String text = this.editor.getCellEditorValueAsText();
                this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
                return false;
            }
            if (dataType.equals(this.dt)) {
                this.fireEditingCanceled();
            } else {
                this.dt = dataType;
                this.fireEditingStopped();
            }
        }
        catch (IllegalArgumentException ex) {
            String text = this.editor.getCellEditorValueAsText();
            this.dialog.setStatusText("Invalid data type: " + text, MessageType.ERROR);
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    DataTypeSelectionEditor getEditor() {
        return this.editor;
    }
}

