/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.datawindow.DataWindowContext;
import ghidra.app.plugin.core.datawindow.DataWindowProvider;
import ghidra.app.plugin.core.datawindow.FilterAction;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramTreeService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays defined data", description="This plugin provides a component for showing all the defined data in the current program.  The data display can be filtered and used for navigation.", servicesRequired={GoToService.class}, eventsConsumed={ViewChangedPluginEvent.class})
public class DataWindowPlugin
extends ProgramPlugin
implements DomainObjectListener,
OptionsChangeListener {
    private DockingAction selectAction;
    private FilterAction filterAction;
    private DataWindowProvider provider;
    private SwingUpdateManager resetUpdateMgr = new SwingUpdateManager(100, 60000, new Runnable(){

        @Override
        public void run() {
            DataWindowPlugin.this.doReset();
        }
    });
    private SwingUpdateManager reloadUpdateMgr = new SwingUpdateManager(100, 60000, new Runnable(){

        @Override
        public void run() {
            DataWindowPlugin.this.doReload();
        }
    });
    private boolean resetTypesNeeded;

    public DataWindowPlugin(PluginTool tool) {
        super(tool, true, true);
    }

    public void init() {
        super.init();
        this.provider = new DataWindowProvider(this);
        this.createActions();
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        this.resetUpdateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.provider.dispose();
        super.dispose();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4)) {
            this.resetTypes();
            this.reload();
            return;
        }
        if (ev.containsEvent(104) || ev.containsEvent(108) || ev.containsEvent(107) || ev.containsEvent(106) || ev.containsEvent(110) || ev.containsEvent(109)) {
            this.resetTypes();
        }
        if (ev.containsEvent(23) || ev.containsEvent(21) || ev.containsEvent(31)) {
            this.reload();
            return;
        }
        if (ev.containsEvent(30)) {
            for (int i = 0; i < ev.numRecords(); ++i) {
                ProgramChangeRecord rec;
                DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
                int eventType = doRecord.getEventType();
                if (eventType != 30 || !((rec = (ProgramChangeRecord)doRecord).getNewValue() instanceof Data)) continue;
                this.provider.dataAdded(rec.getStart());
            }
        }
    }

    void reload() {
        this.reloadUpdateMgr.update();
    }

    void doReload() {
        this.provider.reload();
    }

    @Override
    public void processEvent(PluginEvent event) {
        if (event instanceof ViewChangedPluginEvent) {
            if (this.filterAction.getViewMode() && this.provider.isVisible()) {
                this.reload();
            }
        } else {
            super.processEvent(event);
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.programOpened(program);
        this.filterAction.programOpened(program);
        this.resetTypes();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.programClosed();
        this.filterAction.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    ProgramSelection getSelection() {
        return this.currentSelection;
    }

    DataWindowProvider getProvider() {
        return this.provider;
    }

    private void createActions() {
        this.selectAction = new DockingAction("Make Selection", this.getName(), false){

            public void actionPerformed(ActionContext context) {
                DataWindowPlugin.this.selectData(DataWindowPlugin.this.provider.selectData());
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof DataWindowContext)) {
                    return false;
                }
                DataWindowContext dataWindowContext = (DataWindowContext)context;
                GhidraTable table = dataWindowContext.getDataTable();
                return table.getSelectedRows().length > 0;
            }
        };
        this.selectAction.setEnabled(false);
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        this.selectAction.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)icon));
        this.selectAction.setDescription("Selects currently selected data in table");
        this.selectAction.setToolBarData(new ToolBarData((Icon)icon));
        this.installDummyAction(this.selectAction);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
        this.filterAction = new FilterAction(this);
        this.filterAction.setEnabled(this.currentProgram != null);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.filterAction);
        SelectionNavigationAction selectionAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionAction);
    }

    private void installDummyAction(DockingAction action) {
        DummyKeyBindingsOptionsAction dummyAction = new DummyKeyBindingsOptionsAction(action.getName(), null);
        this.tool.addAction((DockingActionIf)dummyAction);
        ToolOptions options = this.tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyAction.getFullName(), null);
        if (keyStroke != null) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith(this.selectAction.getName())) {
            KeyStroke keyStroke = (KeyStroke)newValue;
            this.selectAction.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    void selectData(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
        this.processEvent(pspe);
    }

    private void resetTypes() {
        if (this.provider.isVisible()) {
            this.resetUpdateMgr.update();
        } else {
            this.resetTypesNeeded = true;
        }
    }

    private void doReset() {
        this.resetTypesNeeded = false;
        ArrayList<String> selectedList = this.filterAction.getSelectedTypes();
        this.filterAction.clearTypes();
        if (this.currentProgram != null) {
            DataTypeManager typeManager = this.currentProgram.getDataTypeManager();
            Iterator itr = typeManager.getAllDataTypes();
            while (itr.hasNext()) {
                DataType type = (DataType)itr.next();
                this.filterAction.addType(type.getDisplayName());
            }
            this.filterAction.selectTypes(selectedList);
            this.filterAction.repaint();
            this.provider.reload();
        }
    }

    public boolean typeEnabled(String type) {
        return this.filterAction.typeEnabled(type);
    }

    public AddressSet getLimitedAddresses() {
        ProgramTreeService service;
        if (this.filterAction.getSelectionMode()) {
            AddressSet ret = new AddressSet();
            AddressRangeIterator itr = this.currentSelection.getAddressRanges();
            while (itr.hasNext()) {
                ret.add((AddressRange)itr.next());
            }
            return ret;
        }
        if (this.filterAction.getViewMode() && (service = (ProgramTreeService)this.tool.getService(ProgramTreeService.class)) != null) {
            return service.getView();
        }
        return null;
    }

    public void readConfigState(SaveState saveState) {
        this.filterAction.setSelected(true);
    }

    public void dataWindowShown() {
        if (this.resetTypesNeeded) {
            this.resetTypes();
        }
    }
}

