/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.internal.DefaultGTreeDataTransformer;
import docking.widgets.tree.support.GTreeRenderer;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.BackgroundIcon;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.CenterVerticalIcon;
import ghidra.app.plugin.core.datamgr.tree.DataTypeDragNDropHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DomainFileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.util.FilterTransformer;
import ghidra.util.UniversalID;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class DataTypeArchiveGTree
extends GTree {
    private static ImageIcon LOCAL_DELTA_ICON = ResourceManager.loadImage((String)"images/smallRightArrow.png");
    private static ImageIcon SOURCE_DELTA_ICON = ResourceManager.loadImage((String)"images/smallLeftArrow.png");
    private static ImageIcon CONFLICT_ICON = ResourceManager.loadImage((String)"images/doubleArrow.png");
    private static ImageIcon MISSING_ICON = ResourceManager.loadImage((String)"images/redQuestionMark.png");
    private DataTypeManagerPlugin plugin;
    private GTreeNode armedNode;
    private MyFolderListener folderListener;
    private DataTypeTreeExpansionListener cleanupListener = new DataTypeTreeExpansionListener();
    private boolean filterArrays = true;
    private boolean filterPointers = true;

    public DataTypeArchiveGTree(DataTypeManagerPlugin dataTypeManagerPlugin) {
        super((GTreeRootNode)new ArchiveRootNode(dataTypeManagerPlugin.getDataTypeManagerHandler()));
        ProjectData projectData;
        this.plugin = dataTypeManagerPlugin;
        this.setDragNDropHandler(new DataTypeDragNDropHandler(this.plugin, (Component)((Object)this)));
        DataTypeTreeRenderer renderer = new DataTypeTreeRenderer();
        this.setRowHeight(this.getHeight(this.getRootNode(), renderer));
        this.setCellRenderer(renderer);
        Project project = this.plugin.getTool().getProject();
        if (project != null && (projectData = project.getProjectData()) != null) {
            this.folderListener = new MyFolderListener();
            projectData.addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        }
        this.addTreeExpansionListener(this.cleanupListener);
    }

    private int getHeight(GTreeRootNode rootNode, DataTypeTreeRenderer renderer) {
        Component c = renderer.getTreeCellRendererComponent(this.getJTree(), rootNode, false, false, false, 0, false);
        Dimension size = c.getPreferredSize();
        return size.height;
    }

    public void expandedStateRestored(TaskMonitor monitor) {
        GTreeRootNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return;
        }
        monitor.setMessage("Recycling unused tree nodes");
        monitor.initialize((long)rootNode.getLeafCount());
        this.reclaimClosedNodes((GTreeNode)rootNode, monitor);
    }

    private void reclaimClosedNodes(GTreeNode node, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        if (!this.isExpanded(node.getTreePath())) {
            int leafCount = node.getLeafCount();
            if (node instanceof GTreeLazyNode) {
                ((GTreeLazyNode)node).removeAll();
            }
            monitor.incrementProgress((long)leafCount);
            return;
        }
        List children = node.getChildren();
        for (GTreeNode child : children) {
            this.reclaimClosedNodes(child, monitor);
        }
    }

    public void dispose() {
        ((ArchiveRootNode)this.getRootNode()).dispose();
        PluginTool tool = this.plugin.getTool();
        if (tool == null) {
            return;
        }
        Project project = tool.getProject();
        if (project == null) {
            return;
        }
        ProjectData projectData = project.getProjectData();
        if (projectData != null) {
            projectData.removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        }
        super.dispose();
    }

    public void enableArrayFilter(boolean enabled) {
        this.filterArrays = enabled;
        this.reloadTree();
    }

    public void enablePointerFilter(boolean enabled) {
        this.filterPointers = enabled;
        this.reloadTree();
    }

    public void setIncludeDataTypeMembersInSearch(boolean includeDataTypes) {
        this.setDataTransformer((FilterTransformer)(includeDataTypes ? new DataTypeTransformer() : new DefaultGTreeDataTransformer()));
        this.reloadTree();
    }

    private void reloadTree() {
        GTreeState treeState = this.getTreeState();
        ArchiveRootNode rootNode = (ArchiveRootNode)this.getRootNode();
        rootNode.removeAll();
        rootNode.getChildCount();
        this.updateModelFilter();
        this.restoreTreeState(treeState);
    }

    public boolean isFilterPointers() {
        return this.filterPointers;
    }

    public boolean isFilterArrays() {
        return this.filterArrays;
    }

    public void setNodeEditable(GTreeNode node) {
        this.armedNode = node;
    }

    public boolean isPathEditable(TreePath path) {
        boolean isArmed = path.getLastPathComponent() == this.armedNode;
        this.armedNode = null;
        if (isArmed) {
            return super.isPathEditable(path);
        }
        return false;
    }

    public String getToolTipText(MouseEvent event) {
        Point point = event.getPoint();
        GTreeNode node = this.getNodeForLocation(point.x, point.y);
        String customTip = this.getToolTipTextForNode(node);
        if (customTip != null) {
            return customTip;
        }
        return super.getToolTipText(event);
    }

    private String getToolTipTextForNode(GTreeNode node) {
        SourceArchive sourceArchive;
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        if (!this.hasOtherSourceArchive(dataType, sourceArchive = dataType.getSourceArchive())) {
            return null;
        }
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState status = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        switch (status) {
            case CONFLICT: 
            case UPDATE: 
            case COMMIT: {
                return DataTypeSynchronizer.getDiffToolTip(handler, dataType);
            }
        }
        return null;
    }

    private boolean hasOtherSourceArchive(DataType dataType, SourceArchive sourceArchive) {
        if (sourceArchive == null) {
            return false;
        }
        if (sourceArchive.getArchiveType().isBuiltIn()) {
            return false;
        }
        UniversalID localID = dataType.getDataTypeManager().getUniversalID();
        return !sourceArchive.getSourceArchiveID().equals((Object)localID);
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            List archiveNodes = DataTypeArchiveGTree.this.getRootNode().getChildren();
            for (GTreeNode treeNode : archiveNodes) {
                ProjectArchiveNode projectArchiveNode;
                DomainFile nodesDomainFile;
                if (!(treeNode instanceof ProjectArchiveNode) || !file.equals(nodesDomainFile = (projectArchiveNode = (ProjectArchiveNode)treeNode).getDomainFile())) continue;
                projectArchiveNode.nodeChanged();
                return;
            }
        }

        public void domainFileRemoved(DomainFolder parentFolder, String name, String fileID) {
        }
    }

    private class DataTypeTreeRenderer
    extends GTreeRenderer {
        private static final int ICON_WIDTH = 24;
        private static final int ICON_HEIGHT = 18;

        private DataTypeTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focus) {
            DomainFileArchiveNode node;
            String info;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, focus);
            label.setBackground(tree.getBackground());
            MultiIcon multiIcon = new MultiIcon((Icon)new BackgroundIcon(24, 18, false));
            Icon icon = this.getIcon();
            multiIcon.addIcon((Icon)new CenterVerticalIcon(icon, 18));
            if (value instanceof DataTypeNode) {
                String displayName = ((DataTypeNode)value).getDisplayName();
                label.setText(displayName);
            } else if (value instanceof DomainFileArchiveNode && (info = (node = (DomainFileArchiveNode)value).getDomainObjectInfo()).length() > 0) {
                label.setText(label.getText() + info);
            }
            this.decorateWithArchiveCharacteristics(value, label, multiIcon);
            if (value instanceof ArchiveNode) {
                this.updateIconForChangeIndicator((ArchiveNode)value, multiIcon);
            }
            this.setIcon((Icon)multiIcon);
            return label;
        }

        private void decorateWithArchiveCharacteristics(Object value, JLabel label, MultiIcon multiIcon) {
            SourceArchive sourceArchive;
            if (value instanceof FileArchiveNode) {
                FileArchiveNode archiveNode = (FileArchiveNode)value;
                FileArchive archive = (FileArchive)archiveNode.getArchive();
                if (archive.isChanged()) {
                    label.setText(label.getText() + " *");
                }
                return;
            }
            if (!(value instanceof DataTypeNode)) {
                return;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)value;
            DataType dataType = dataTypeNode.getDataType();
            if (!DataTypeArchiveGTree.this.hasOtherSourceArchive(dataType, sourceArchive = dataType.getSourceArchive())) {
                return;
            }
            DataTypeManagerHandler handler = DataTypeArchiveGTree.this.plugin.getDataTypeManagerHandler();
            DataTypeSyncState status = DataTypeSynchronizer.getSyncStatus(handler, dataType);
            switch (status) {
                case CONFLICT: {
                    multiIcon.addIcon((Icon)new TranslateIcon((Icon)CONFLICT_ICON, 10, 5));
                    break;
                }
                case UPDATE: {
                    multiIcon.addIcon((Icon)new TranslateIcon((Icon)SOURCE_DELTA_ICON, 14, 5));
                    break;
                }
                case COMMIT: {
                    multiIcon.addIcon((Icon)new TranslateIcon((Icon)LOCAL_DELTA_ICON, 14, 5));
                    break;
                }
                case ORPHAN: {
                    multiIcon.addIcon((Icon)new TranslateIcon((Icon)MISSING_ICON, 10, 4));
                    break;
                }
            }
        }

        private void updateIconForChangeIndicator(ArchiveNode node, MultiIcon multiIcon) {
            DataTypeManager dtm = node.getArchive().getDataTypeManager();
            if (dtm == null) {
                return;
            }
            List sourceArchives = dtm.getSourceArchives();
            if (sourceArchives.isEmpty()) {
                return;
            }
            boolean hasLocalChanges = this.checkForLocalChanges(sourceArchives);
            boolean hasUpdatesAvailable = this.checkforUpdates(sourceArchives);
            if (hasLocalChanges && hasUpdatesAvailable) {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)CONFLICT_ICON, 6, 9));
            } else if (hasLocalChanges) {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)LOCAL_DELTA_ICON, 6, 9));
            } else if (hasUpdatesAvailable) {
                multiIcon.addIcon((Icon)new TranslateIcon((Icon)SOURCE_DELTA_ICON, 6, 9));
            }
        }

        private boolean checkforUpdates(List<SourceArchive> sourceArchives) {
            for (SourceArchive sourceArchive : sourceArchives) {
                DataTypeManager sourceDTM = DataTypeArchiveGTree.this.plugin.getDataTypeManagerHandler().getDataTypeManager(sourceArchive);
                if (sourceDTM == null || sourceArchive.getLastSyncTime() == sourceDTM.getLastChangeTimeForMyManager()) continue;
                return true;
            }
            return false;
        }

        private boolean checkForLocalChanges(List<SourceArchive> sourceArchives) {
            for (SourceArchive sourceArchive : sourceArchives) {
                if (!sourceArchive.isDirty()) continue;
                return true;
            }
            return false;
        }
    }

    private class DataTypeTreeExpansionListener
    implements TreeExpansionListener {
        private DataTypeTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (DataTypeArchiveGTree.this.isFiltered()) {
                return;
            }
            TreePath path = event.getPath();
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof CategoryNode) {
                CategoryNode categoryNode = (CategoryNode)node;
                categoryNode.removeAll();
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    private class DataTypeTransformer
    extends DefaultGTreeDataTransformer {
        private DataTypeTransformer() {
        }

        public List<String> transform(GTreeNode node) {
            List results = super.transform(node);
            if (!(node instanceof DataTypeNode)) {
                return results;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (dataType instanceof Enum) {
                this.addEnumStrings((Enum)dataType, results);
            } else if (dataType instanceof Composite) {
                this.addCompositeStrings((Composite)dataType, results);
            } else if (dataType instanceof FunctionDefinition) {
                this.addFunctionDefinitionStrings((FunctionDefinition)dataType, results);
            }
            return results;
        }

        private void addFunctionDefinitionStrings(FunctionDefinition function, List<String> results) {
            results.add(function.getPrototypeString());
        }

        private void addCompositeStrings(Composite composite, List<String> results) {
            DataTypeComponent[] components;
            for (DataTypeComponent component : components = composite.getComponents()) {
                String fieldName = component.getFieldName();
                if (fieldName != null) {
                    results.add(fieldName);
                }
                DataType compDataType = component.getDataType();
                results.add(compDataType.getName());
            }
        }

        private void addEnumStrings(Enum enumm, List<String> results) {
            for (String valueName : enumm.getNames()) {
                results.add(valueName);
            }
            for (long value : enumm.getValues()) {
                results.add(Long.toString(value));
                results.add("0x" + Long.toHexString(value));
            }
        }
    }
}

