/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import ghidra.util.UniversalID;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ChooseArchiveDialog
extends DialogComponentProvider {
    private JPanel archiveListPanel;
    private JTextField filterField;
    private boolean removeWasCanceled;
    private Archive currentArchive;
    private List<Archive> archiveList;
    private JList list;
    private DefaultListModel listModel;

    public ChooseArchiveDialog(Plugin plugin, String title, Archive currentArchive, List<Archive> archiveList) {
        super(title);
        this.currentArchive = currentArchive;
        this.archiveList = archiveList;
        this.createArchiveListPanel();
        this.filterField = this.getFilterField();
        this.addWorkPanel(this.archiveListPanel);
        this.addOKButton();
        this.setOkToolTip("Choose the archive file to synchronize.");
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Choose_Archive"));
    }

    public boolean wasCanceled() {
        return this.removeWasCanceled;
    }

    protected void cancelCallback() {
        this.removeWasCanceled = true;
        this.clearStatusText();
        this.close();
    }

    protected void okCallback() {
        this.clearStatusText();
        Archive selectedArchive = this.getSelectedArchive();
        if (selectedArchive == null) {
            this.setStatusText("Please select an archive to synchronize.");
            return;
        }
        this.close();
    }

    JList getList() {
        return this.list;
    }

    JTextField getFilterField() {
        return this.filterField;
    }

    public Archive getSelectedArchive() {
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            return (Archive)this.listModel.get(index);
        }
        return null;
    }

    void selectArchive(Archive archive) {
        int index = this.listModel.indexOf(archive);
        this.list.setSelectedIndex(index);
    }

    private void createArchiveListPanel() {
        this.archiveListPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel();
        String instructions = "<HTML>Choose the archive to synchronize with <B>" + this.currentArchive.getName() + "</B>.</HTML>";
        JLabel instructionLabel = new JLabel(instructions);
        northPanel.add((Component)instructionLabel, "North");
        northPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 8, 3));
        this.archiveListPanel.add((Component)northPanel, "North");
        this.listModel = new DefaultListModel();
        this.initListModel();
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new MyListCellRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && ChooseArchiveDialog.this.list.getSelectedValue() != null) {
                    ChooseArchiveDialog.this.okCallback();
                }
            }
        });
        int size = this.listModel.getSize();
        this.list.setVisibleRowCount(size);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        this.filterField = this.createFilterField();
        southPanel.add(new JLabel("Filter: "));
        southPanel.add(this.filterField);
        southPanel.setBorder(BorderFactory.createEmptyBorder(8, 3, 8, 3));
        this.archiveListPanel.add((Component)southPanel, "South");
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)scrollPane, "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.archiveListPanel.add(listPanel);
    }

    private JTextField createFilterField() {
        JTextField newFilterField = new JTextField(20);
        newFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter(e.getDocument());
            }

            private void filter(Document document) {
                try {
                    String text = document.getText(0, document.getLength());
                    ChooseArchiveDialog.this.filterList(text);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return newFilterField;
    }

    private void filterList(String filterText) {
        boolean hasFilter;
        ArrayList<Archive> allDataList = new ArrayList<Archive>();
        allDataList.addAll(this.archiveList);
        boolean bl = hasFilter = filterText.trim().length() != 0;
        if (hasFilter) {
            String lowerCaseFilterText = filterText.toLowerCase();
            Iterator iterator = allDataList.iterator();
            while (iterator.hasNext()) {
                Archive archive = (Archive)iterator.next();
                String archiveString = this.getStringUsedInList(archive).toLowerCase();
                if (archiveString.indexOf(lowerCaseFilterText) >= 0) continue;
                iterator.remove();
            }
        }
        this.listModel.clear();
        for (Archive archive : allDataList) {
            this.listModel.addElement(archive);
        }
        int totalListSize = this.archiveList.size();
        int shownListSize = this.listModel.getSize();
        if (shownListSize > 0) {
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex < 0) {
                this.list.setSelectedIndex(0);
            }
            if (shownListSize == totalListSize) {
                this.clearStatusText();
            } else {
                this.setStatusText("Filter is hiding " + (totalListSize - shownListSize) + " of the archive choices.");
            }
        } else {
            this.setStatusText("Filter is hiding all possible archive choices.");
        }
    }

    private String getStringUsedInList(Archive archive) {
        return archive.getName();
    }

    private void initListModel() {
        this.listModel.clear();
        for (int i = 0; i < this.archiveList.size(); ++i) {
            Archive archive = this.archiveList.get(i);
            UniversalID sourceID = this.currentArchive.getDataTypeManager().getUniversalID();
            SourceArchive sourceArchive = archive.getDataTypeManager().getSourceArchive(sourceID);
            if (sourceArchive == null) continue;
            this.listModel.addElement(archive);
        }
    }

    private class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList localList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Archive archive = (Archive)value;
            this.setIcon(archive.getIcon(false));
            this.setIconTextGap(5);
            String text = ChooseArchiveDialog.this.getStringUsedInList(archive);
            this.setText(text);
            if (isSelected) {
                this.setBackground(localList.getSelectionBackground());
                this.setForeground(localList.getSelectionForeground());
            } else {
                this.setBackground(localList.getBackground());
                this.setForeground(localList.getForeground());
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 10));
            return this;
        }
    }
}

