/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveFileChooser;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.framework.store.LockException;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveUtils {
    static final Logger log = LogManager.getLogger(ArchiveUtils.class);

    private ArchiveUtils() {
    }

    public static void saveAs(Component component, FileArchive archive) throws DuplicateFileException, IOException {
        File saveAsFile = ArchiveUtils.getFile(component, archive);
        if (saveAsFile == null) {
            return;
        }
        if (saveAsFile.equals(archive.getFile())) {
            archive.save();
        } else {
            archive.saveAs(saveAsFile);
        }
    }

    public static void save(Component component, Archive archive) throws DuplicateFileException, IOException {
        if (!archive.isSavable()) {
            archive.saveAs(component);
        } else {
            archive.save();
        }
    }

    public static boolean canClose(List<Archive> archiveList, Component component) {
        for (Archive archive : archiveList) {
            if (ArchiveUtils.canClose(archive, component)) continue;
            return false;
        }
        return true;
    }

    public static boolean lockArchive(FileArchive archive) {
        try {
            archive.acquireWriteLock();
            return true;
        }
        catch (ReadOnlyException e) {
            Msg.showError((Object)log, null, (String)"Unable to Lock File for Writing", (Object)e.getMessage());
        }
        catch (LockException exc) {
            Msg.showError((Object)log, null, (String)"Unable to Lock File for Writing", (Object)("Unable to obtain lock for archive: " + archive.getName() + "\n" + exc.getMessage()));
        }
        catch (IOException ioe) {
            Msg.showError((Object)log, null, (String)"Unable to Lock File for Writing", (Object)("Problem attempting to lock archive: " + archive.getName() + "\n" + ioe.getMessage()));
        }
        return false;
    }

    static File getFile(Component component, FileArchive archive) {
        ArchiveFileChooser fileChooser = new ArchiveFileChooser(component);
        String archiveName = archive.getName();
        File file = fileChooser.promptUserForFile(archiveName);
        if (file == null) {
            return null;
        }
        if (file.equals(archive.getFile())) {
            return file;
        }
        if (archive.getArchiveManager().isInUse(file)) {
            Msg.showInfo(ArchiveUtils.class, (Component)component, (String)"Cannot Perform Save As", (Object)("Cannot save archive to " + file.getName() + "\nbecause " + file.getName() + " is in use."));
            return null;
        }
        if (file.exists()) {
            if (OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)component, (String)"Overwrite Existing File?", (String)("Do you want to overwrite existing file\n" + file.getAbsolutePath())) != 1) {
                return null;
            }
            if (!ArchiveUtils.deleteArchiveFile(file)) {
                Msg.showError((Object)log, (Component)component, (String)"Error Deleting File", (Object)("Could not delete file " + file.getAbsolutePath()));
                return null;
            }
        }
        return file;
    }

    private static boolean deleteArchiveFile(File file) {
        try {
            FileDataTypeManager.delete((File)file);
            return true;
        }
        catch (Exception exception) {
            return file.delete();
        }
    }

    public static boolean canClose(Archive archive, Component component) {
        if (!archive.isChanged()) {
            return true;
        }
        int result = OptionDialog.showYesNoCancelDialog((Component)component, (String)"Save Archive?", (String)("Datatype Archive \"" + archive.getName() + "\" has been changed.\n Do you want to save the changes?"));
        if (result == 0) {
            return false;
        }
        if (result == 2) {
            if (archive instanceof FileArchive) {
                try {
                    ((FileArchive)archive).releaseWriteLock();
                }
                catch (IOException e) {
                    Msg.showError((Object)log, (Component)component, (String)"Unable to release File Archive write lock.", (Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        return ArchiveUtils.saveArchive(archive, component);
    }

    private static boolean saveArchive(Archive archive, Component component) {
        try {
            ArchiveUtils.save(component, archive);
            return true;
        }
        catch (DuplicateFileException e) {
            Msg.showError((Object)log, (Component)component, (String)"Unable to Save Archive", (Object)("Archive already exists: " + archive), (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)log, (Component)component, (String)"Unable to Save Archive", (Object)("Unexpected exception attempting to save archive: " + archive), (Throwable)e);
        }
        return false;
    }
}

