/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataOrganizationPanel
extends JPanel {
    JCheckBox charIsSignedCheckbox;
    JTextField charSizeComponent;
    JTextField wcharSizeComponent;
    JTextField shortSizeComponent;
    JTextField integerSizeComponent;
    JTextField longSizeComponent;
    JTextField longLongSizeComponent;
    JTextField floatSizeComponent;
    JTextField doubleSizeComponent;
    JTextField longDoubleSizeComponent;
    JTextField absoluteMaxAlignComponent;
    JTextField machineAlignComponent;
    JTextField defaultAlignComponent;
    JTextField pointerAlignComponent;
    DataOrganizationImpl dataOrganization;

    public DataOrganizationPanel() {
        super((LayoutManager)new PairLayout(3, 5));
        this.setUpAbsoluteMaxAlignment();
        this.setUpMachineAlignment();
        this.setUpDefaultAlignment();
        this.setUpPointerAlignment();
        this.setUpSignedChar();
        this.setUpCharSize();
        this.setUpWideCharSize();
        this.setUpShortSize();
        this.setUpIntegerSize();
        this.setUpLongSize();
        this.setUpLongLongSize();
        this.setUpFloatSize();
        this.setUpDoubleSize();
        this.setUpLongDoubleSize();
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.add(new JLabel("Absolute Max Alignment"));
        this.add(this.absoluteMaxAlignComponent);
        this.add(new JLabel("Machine Alignment"));
        this.add(this.machineAlignComponent);
        this.add(new JLabel("Default Alignment"));
        this.add(this.defaultAlignComponent);
        this.add(new JLabel("Default Pointer Alignment"));
        this.add(this.pointerAlignComponent);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
        this.add(new JLabel("Signed-Char:"));
        this.add(this.charIsSignedCheckbox);
        this.add(new JLabel("Char Size"));
        this.add(this.charSizeComponent);
        this.add(new JLabel("Wide-Char Size"));
        this.add(this.wcharSizeComponent);
        this.add(new JLabel("Short Size"));
        this.add(this.shortSizeComponent);
        this.add(new JLabel("Integer Size"));
        this.add(this.integerSizeComponent);
        this.add(new JLabel("Long Size"));
        this.add(this.longSizeComponent);
        this.add(new JLabel("LongLong Size"));
        this.add(this.longLongSizeComponent);
        this.add(new JLabel("Float Size"));
        this.add(this.floatSizeComponent);
        this.add(new JLabel("Double Size"));
        this.add(this.doubleSizeComponent);
        this.add(new JLabel("LongDouble Size"));
        this.add(this.longDoubleSizeComponent);
        this.add(new JLabel(""));
        this.add(new JLabel(""));
    }

    public void setOrganization(DataOrganizationImpl dataOrganization) {
        this.dataOrganization = dataOrganization;
        int absoluteMaxAlignment = dataOrganization.getAbsoluteMaxAlignment();
        int machineAlignment = dataOrganization.getMachineAlignment();
        int defaultAlignment = dataOrganization.getDefaultAlignment();
        int defaultPointerAlignment = dataOrganization.getDefaultPointerAlignment();
        int charSize = dataOrganization.getCharSize();
        int wcharSize = dataOrganization.getWideCharSize();
        int shortSize = dataOrganization.getShortSize();
        int integerSize = dataOrganization.getIntegerSize();
        int longSize = dataOrganization.getLongSize();
        int longLongSize = dataOrganization.getLongLongSize();
        int floatSize = dataOrganization.getFloatSize();
        int doubleSize = dataOrganization.getDoubleSize();
        int longDoubleSize = dataOrganization.getLongDoubleSize();
        String maxAlignString = absoluteMaxAlignment == 0 ? "none" : Integer.toString(absoluteMaxAlignment);
        this.absoluteMaxAlignComponent.setText(maxAlignString);
        this.machineAlignComponent.setText(Integer.toString(machineAlignment));
        this.defaultAlignComponent.setText(Integer.toString(defaultAlignment));
        this.pointerAlignComponent.setText(Integer.toString(defaultPointerAlignment));
        this.charSizeComponent.setText(Integer.toString(charSize));
        this.wcharSizeComponent.setText(Integer.toString(wcharSize));
        this.shortSizeComponent.setText(Integer.toString(shortSize));
        this.integerSizeComponent.setText(Integer.toString(integerSize));
        this.longSizeComponent.setText(Integer.toString(longSize));
        this.longLongSizeComponent.setText(Integer.toString(longLongSize));
        this.floatSizeComponent.setText(Integer.toString(floatSize));
        this.doubleSizeComponent.setText(Integer.toString(doubleSize));
        this.longDoubleSizeComponent.setText(Integer.toString(longDoubleSize));
    }

    private void setUpSignedChar() {
        this.charIsSignedCheckbox = new JCheckBox();
        this.charIsSignedCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataOrganizationPanel.this.updateSignedChar();
            }
        });
    }

    private void setUpCharSize() {
        this.charSizeComponent = new JTextField(3);
        this.charSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedCharSize();
            }
        });
        this.charSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedCharSize();
            }
        });
    }

    private void setUpWideCharSize() {
        this.wcharSizeComponent = new JTextField(3);
        this.wcharSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedWideCharSize();
            }
        });
        this.wcharSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedWideCharSize();
            }
        });
    }

    private void setUpShortSize() {
        this.shortSizeComponent = new JTextField(3);
        this.shortSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedShortSize();
            }
        });
        this.shortSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedShortSize();
            }
        });
    }

    private void setUpIntegerSize() {
        this.integerSizeComponent = new JTextField(3);
        this.integerSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedIntegerSize();
            }
        });
        this.integerSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedIntegerSize();
            }
        });
    }

    private void setUpLongSize() {
        this.longSizeComponent = new JTextField(3);
        this.longSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedLongSize();
            }
        });
        this.longSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedLongSize();
            }
        });
    }

    private void setUpLongLongSize() {
        this.longLongSizeComponent = new JTextField(3);
        this.longLongSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedLongLongSize();
            }
        });
        this.longLongSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedLongLongSize();
            }
        });
    }

    private void setUpFloatSize() {
        this.floatSizeComponent = new JTextField(3);
        this.floatSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedFloatSize();
            }
        });
        this.floatSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedFloatSize();
            }
        });
    }

    private void setUpDoubleSize() {
        this.doubleSizeComponent = new JTextField(3);
        this.doubleSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedDoubleSize();
            }
        });
        this.doubleSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedDoubleSize();
            }
        });
    }

    private void setUpLongDoubleSize() {
        this.longDoubleSizeComponent = new JTextField(3);
        this.longDoubleSizeComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedLongDoubleSize();
            }
        });
        this.longDoubleSizeComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedLongDoubleSize();
            }
        });
    }

    private void setUpAbsoluteMaxAlignment() {
        this.absoluteMaxAlignComponent = new JTextField(3);
        this.absoluteMaxAlignComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedAbsoluteMaxAlignment();
            }
        });
        this.absoluteMaxAlignComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedAbsoluteMaxAlignment();
            }
        });
    }

    private void setUpMachineAlignment() {
        this.machineAlignComponent = new JTextField(3);
        this.machineAlignComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedMachineAlignment();
            }
        });
        this.machineAlignComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedMachineAlignment();
            }
        });
    }

    private void setUpDefaultAlignment() {
        this.defaultAlignComponent = new JTextField(3);
        this.defaultAlignComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedDefaultAlignment();
            }
        });
        this.defaultAlignComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedDefaultAlignment();
            }
        });
    }

    private void setUpPointerAlignment() {
        this.pointerAlignComponent = new JTextField(3);
        this.pointerAlignComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataOrganizationPanel.this.updatedDefaultPointerAlignment();
            }
        });
        this.pointerAlignComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataOrganizationPanel.this.updatedDefaultPointerAlignment();
            }
        });
    }

    protected void updateSignedChar() {
        boolean isSigned = this.charIsSignedCheckbox.isSelected();
        this.dataOrganization.setCharIsSigned(isSigned);
    }

    protected void updatedCharSize() {
        int charSize = Integer.decode(this.charSizeComponent.getText());
        this.dataOrganization.setCharSize(charSize);
    }

    protected void updatedWideCharSize() {
        int wcharSize = Integer.decode(this.wcharSizeComponent.getText());
        this.dataOrganization.setWideCharSize(wcharSize);
    }

    protected void updatedShortSize() {
        int shortSize = Integer.decode(this.shortSizeComponent.getText());
        this.dataOrganization.setShortSize(shortSize);
    }

    protected void updatedIntegerSize() {
        int integerSize = Integer.decode(this.integerSizeComponent.getText());
        this.dataOrganization.setIntegerSize(integerSize);
    }

    protected void updatedLongSize() {
        int longSize = Integer.decode(this.longSizeComponent.getText());
        this.dataOrganization.setLongSize(longSize);
    }

    protected void updatedLongLongSize() {
        int longLongSize = Integer.decode(this.longLongSizeComponent.getText());
        this.dataOrganization.setLongLongSize(longLongSize);
    }

    protected void updatedFloatSize() {
        int floatSize = Integer.decode(this.floatSizeComponent.getText());
        this.dataOrganization.setFloatSize(floatSize);
    }

    protected void updatedDoubleSize() {
        int doubleSize = Integer.decode(this.doubleSizeComponent.getText());
        this.dataOrganization.setDoubleSize(doubleSize);
    }

    protected void updatedLongDoubleSize() {
        int longDoubleSize = Integer.decode(this.longDoubleSizeComponent.getText());
        this.dataOrganization.setLongDoubleSize(longDoubleSize);
    }

    protected void updatedAbsoluteMaxAlignment() {
        String maxAlignString = this.absoluteMaxAlignComponent.getText().toLowerCase();
        int absoluteMax = "none".equals(maxAlignString) ? 0 : Integer.decode(maxAlignString);
        this.dataOrganization.setAbsoluteMaxAlignment(absoluteMax);
    }

    protected void updatedMachineAlignment() {
        int machineAlignment = Integer.decode(this.machineAlignComponent.getText());
        this.dataOrganization.setMachineAlignment(machineAlignment);
    }

    protected void updatedDefaultAlignment() {
        int defaultAlignment = Integer.decode(this.defaultAlignComponent.getText());
        this.dataOrganization.setDefaultAlignment(defaultAlignment);
    }

    protected void updatedDefaultPointerAlignment() {
        int defaultPointerAlignment = Integer.decode(this.pointerAlignComponent.getText());
        this.dataOrganization.setDefaultPointerAlignment(defaultPointerAlignment);
    }
}

