/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.memory;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

class BlockConflictPanel
extends JPanel {
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private ButtonGroup group;
    private ChangeListener listener;

    BlockConflictPanel(ChangeListener listener) {
        this.listener = listener;
        this.create();
    }

    void setConflictInfo(String latestStr, String myStr, String origStr) {
        this.latestRB.setText(latestStr);
        this.myRB.setText(myStr);
        this.originalRB.setText(origStr);
        this.group.remove(this.latestRB);
        this.group.remove(this.myRB);
        this.group.remove(this.originalRB);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 0;
        }
        if (this.myRB.isSelected()) {
            return 1;
        }
        if (this.originalRB.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void create() {
        BoxLayout bl = new BoxLayout(this, 1);
        this.setLayout(bl);
        this.group = new ButtonGroup();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BlockConflictPanel.this.listener.stateChanged(null);
                }
            }
        };
        this.latestRB = new JRadioButton("Latest");
        this.latestRB.setName("Latest");
        this.latestRB.addItemListener(itemListener);
        this.myRB = new JRadioButton("My");
        this.myRB.addItemListener(itemListener);
        this.myRB.setName("Checked Out");
        this.originalRB = new JRadioButton("Original");
        this.originalRB.addItemListener(itemListener);
        this.originalRB.setName("Original");
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
        this.add(this.latestRB);
        this.add(Box.createVerticalStrut(10));
        this.add(this.myRB);
        this.add(Box.createVerticalStrut(10));
        this.add(this.originalRB);
    }
}

