/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.jmx.remote.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.ConnectException;
import java.util.Timer;
import java.util.TimerTask;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.log.OutLogger;
import org.rzo.netty.ahessian.session.ClientSessionFilter;

public class RPCClientSessionPipelineFactory
extends ChannelPipelineFactory {
    ChannelPipelineFactory _mixinFactory;
    ClientSessionFilter _sessionFilter;
    private static Timer timer = new Timer();
    private static long RECONNECT_DELAY = 5000L;
    Bootstrap _bootstrap;

    RPCClientSessionPipelineFactory(ChannelPipelineFactory mixinFactory, Bootstrap bootstrap) {
        this._mixinFactory = mixinFactory;
        this._sessionFilter = new ClientSessionFilter(this._mixinFactory);
        this._bootstrap = bootstrap;
    }

    @Override
    public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
        ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
        pipeline.addLast("logger", (ChannelHandler)new OutLogger("1"));
        pipeline.addLast("reconnector", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) {
                ctx.fireChannelInactive();
                System.out.println("channel closed wait to reconnect ...");
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.out.println("reconnecting...");
                        ChannelFuture f = RPCClientSessionPipelineFactory.this._bootstrap.connect();
                        try {
                            System.out.println("future wait");
                            f.awaitUninterruptibly();
                            System.out.println("future wait terminated");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (f.isSuccess()) {
                            System.out.println("connected");
                        } else {
                            System.out.println("not connected");
                        }
                    }
                }, RECONNECT_DELAY);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
                Throwable cause = e;
                if (cause instanceof ConnectException) {
                    System.out.println("conection lost");
                }
                ctx.channel().close();
            }
        });
        pipeline.addLast("sessionFilter", (ChannelHandler)this._sessionFilter);
        return pipeline;
    }
}

