/*
 * Decompiled with CFR 0.152.
 */
package util;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class DebugThreadDumper
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) {
        if (args.length != 1) {
            System.err.println("Invalid usage, expected debug port number");
            System.exit(1);
        }
        int port = -1;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (port <= 0 || port >= 65535) {
            System.err.println("Invalid debug port number");
            System.exit(1);
        }
        int jmxPort = port + 1;
        System.out.println("Thread Dump (debug-port=" + port + ", jmx-port=" + jmxPort + ")");
        try {
            System.out.println("Connecting to VM...");
            String url = "service:jmx:rmi:///jndi/rmi://localhost:" + jmxPort + "/jmxrmi";
            JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(url));
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            ThreadMXBean threadBean = ManagementFactory.newPlatformMXBeanProxy(connection, "java.lang:type=Threading", ThreadMXBean.class);
            System.out.println("Dumping threads...");
            this.dumpThreads(threadBean);
        }
        catch (IOException e) {
            System.err.println("Error while dumping VM threads: " + e.getMessage());
        }
    }

    private void dumpThreads(ThreadMXBean threadBean) {
        for (ThreadInfo threadInfo : threadBean.dumpAllThreads(true, true)) {
            this.dumpThreadStack(threadInfo);
        }
    }

    private void dumpThreadStack(ThreadInfo threadInfo) {
        this.dumpThreadInfo(threadInfo);
        for (StackTraceElement stackElement : threadInfo.getStackTrace()) {
            System.out.println("\t" + this.buildLocationString(stackElement));
        }
    }

    private String buildLocationString(StackTraceElement stackElement) {
        StringBuffer buffer = new StringBuffer();
        String methodName = stackElement.getClassName() + "." + stackElement.getMethodName();
        buffer.append(methodName);
        String sourceName = stackElement.getFileName();
        buffer.append(" (").append(sourceName).append(":");
        int lineNumber = stackElement.getLineNumber();
        buffer.append(lineNumber < 0 ? "<unknown source>" : Integer.toString(lineNumber)).append(")");
        return buffer.toString();
    }

    private void dumpThreadInfo(ThreadInfo threadInfo) {
        LockInfo[] lockedSynchronizers;
        MonitorInfo[] monitorInfo;
        Thread.State threadState = threadInfo.getThreadState();
        System.out.println("\n\"" + threadInfo.getThreadName() + "\" id=" + threadInfo.getThreadId() + " state=" + threadState);
        String lockOwner = threadInfo.getLockOwnerName();
        long lockOwnerId = threadInfo.getLockOwnerId();
        String lockName = threadInfo.getLockName();
        if (lockOwner != null) {
            System.out.println("\tWaiting on Monitor:");
            System.out.println("\t\t-" + lockName + ", owner: " + lockOwner + "(" + lockOwnerId + ")");
        }
        if ((monitorInfo = threadInfo.getLockedMonitors()) != null && monitorInfo.length != 0) {
            System.out.println("\tOwned Monitors:");
            for (MonitorInfo monitor : monitorInfo) {
                System.out.println("\t\t-" + monitor);
            }
        }
        if ((lockedSynchronizers = threadInfo.getLockedSynchronizers()) != null && lockedSynchronizers.length != 0) {
            System.out.println("\tOwned Sychronizers:");
            for (LockInfo lock : lockedSynchronizers) {
                System.out.println("\t\t-" + lock);
            }
        }
    }
}

