/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class DoubleArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_SIZE = 4;
    double[] doubles = new double[4];
    int lastNonZeroIndex = -1;

    public void put(int index, double value) {
        if (value == 0.0) {
            this.remove(index);
            return;
        }
        if (index >= this.doubles.length) {
            this.adjustArray(Math.max(index + 1, this.doubles.length * 2));
        }
        this.doubles[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.doubles.length) {
            return;
        }
        this.doubles[index] = 0.0;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.doubles.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.doubles[i] == 0.0) continue;
            return i;
        }
        return -1;
    }

    public double get(int index) {
        if (index < this.doubles.length) {
            return this.doubles[index];
        }
        return 0.0;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        double[] newdoubles = new double[size];
        int len = Math.min(size, this.doubles.length);
        System.arraycopy(this.doubles, 0, newdoubles, 0, len);
        this.doubles = newdoubles;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putDouble(toIndex, toCol, this.get(index));
    }
}

