/*
 * Decompiled with CFR 0.152.
 */
package generic.constraint;

import generic.constraint.Constraint;
import generic.constraint.Decision;
import generic.constraint.DecisionSet;
import ghidra.xml.XmlParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;

public class DecisionNode<T> {
    private Map<String, PropertyValue> propertyMap = new HashedMap();
    private Constraint<T> constraint;
    private List<DecisionNode<T>> children = new ArrayList<DecisionNode<T>>();
    private DecisionNode<T> parent;

    public DecisionNode(Constraint<T> constraint, DecisionNode<T> parent) {
        this.constraint = constraint;
        this.parent = parent;
    }

    public DecisionNode<T> getOrCreateNodeForContraint(Constraint<T> newConstraint) {
        for (DecisionNode<T> child : this.children) {
            if (!newConstraint.equals(child.constraint)) continue;
            return child;
        }
        DecisionNode<T> newChild = new DecisionNode<T>(newConstraint, this);
        this.children.add(newChild);
        return newChild;
    }

    public void setProperty(String propertyName, String value, String source) throws XmlParseException {
        if (this.propertyMap.containsKey(propertyName)) {
            throw new XmlParseException("Attempted to overwrite property value for " + propertyName + " in contraint node: " + this);
        }
        this.propertyMap.put(propertyName, new PropertyValue(value, source));
    }

    public boolean populateDecisions(T t, DecisionSet decisionSet, String propertyName) {
        if (!this.constraint.isSatisfied(t)) {
            return false;
        }
        boolean decisionFound = false;
        for (DecisionNode<T> child : this.children) {
            decisionFound |= child.populateDecisions(t, decisionSet, propertyName);
        }
        if (!decisionFound && this.propertyMap.containsKey(propertyName)) {
            PropertyValue value = this.propertyMap.get(propertyName);
            List<String> decisionPath = this.getDecisionPath();
            decisionSet.addDecision(new Decision(value.value, decisionPath, value.source));
            decisionFound = true;
        }
        return decisionFound;
    }

    protected List<String> getDecisionPath() {
        List<String> decisionPath = this.parent.getDecisionPath();
        decisionPath.add(this.constraint.getDescription());
        return decisionPath;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        List<String> decisionPath = this.getDecisionPath();
        for (String string : decisionPath) {
            buf.append("/");
            buf.append(string);
        }
        return buf.toString();
    }

    static class PropertyValue {
        String value;
        String source;

        PropertyValue(String value, String source) {
            this.value = value;
            this.source = source;
        }
    }
}

