/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.CallbackHandlerImpl;
import org.apache.jackrabbit.core.security.authentication.JAASAuthContext;
import org.apache.jackrabbit.core.security.authentication.LocalAuthContext;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;

public class AuthContextProvider {
    private boolean initialized;
    private boolean isJAAS;
    private final LoginModuleConfig config;
    private final String appName;

    public AuthContextProvider(String appName, LoginModuleConfig config) {
        this.appName = appName;
        this.config = config;
    }

    public AuthContext getAuthContext(Credentials credentials, Subject subject, Session session, PrincipalProviderRegistry principalProviderRegistry, String adminId, String anonymousId) throws RepositoryException {
        CallbackHandlerImpl cbHandler = new CallbackHandlerImpl(credentials, session, principalProviderRegistry, adminId, anonymousId);
        if (this.isJAAS()) {
            return new JAASAuthContext(this.appName, cbHandler, subject);
        }
        if (this.isLocal()) {
            return new LocalAuthContext(this.config, cbHandler, subject);
        }
        throw new RepositoryException("No Login-Configuration");
    }

    public boolean isJAAS() {
        if (!this.initialized) {
            AppConfigurationEntry[] entries = this.getJAASConfig();
            this.isJAAS = null != entries && entries.length > 0;
            this.initialized = true;
        }
        return this.isJAAS;
    }

    public boolean isLocal() {
        return !this.isJAAS() && this.config != null;
    }

    public Properties[] getModuleConfig() {
        Properties[] props = new Properties[]{};
        if (this.isLocal()) {
            props = new Properties[]{this.config.getParameters()};
        } else {
            AppConfigurationEntry[] entries = this.getJAASConfig();
            if (entries != null) {
                ArrayList<Properties> tmp = new ArrayList<Properties>(entries.length);
                for (int i = 0; i < entries.length; ++i) {
                    Map<String, ?> opt = entries[i].getOptions();
                    if (opt == null) continue;
                    Properties prop = new Properties();
                    prop.putAll(opt);
                    tmp.add(prop);
                }
                props = tmp.toArray(new Properties[tmp.size()]);
            }
        }
        return props;
    }

    private AppConfigurationEntry[] getJAASConfig() {
        Configuration logins = null;
        try {
            logins = Configuration.getConfiguration();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (logins != null) {
            try {
                return logins.getAppConfigurationEntry(this.appName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

