/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.picking.PickedState;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public abstract class VisualGraphAbstractGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener,
VisualGraphMousePlugin<V, E> {
    protected boolean isHandlingMouseEvents;
    protected V selectedVertex;
    protected E selectedEdge;

    public VisualGraphAbstractGraphMousePlugin() {
        this(16);
    }

    public VisualGraphAbstractGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
    }

    protected boolean checkForVertex(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            this.selectedVertex = null;
            return false;
        }
        VisualizationViewer vv = this.getViewer(e);
        GraphElementAccessor pickSupport = vv.getPickSupport();
        Layout layout = vv.getGraphLayout();
        if (pickSupport == null) {
            return false;
        }
        Point p = e.getPoint();
        this.selectedVertex = (VisualVertex)pickSupport.getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
        if (this.selectedVertex == null) {
            return false;
        }
        e.consume();
        return true;
    }

    protected boolean checkForEdge(MouseEvent e) {
        if (!this.checkModifiers(e) || this.isOverVertex(e)) {
            this.selectedEdge = null;
            return false;
        }
        VisualizationViewer vv = this.getViewer(e);
        GraphElementAccessor pickSupport = vv.getPickSupport();
        Layout layout = vv.getGraphLayout();
        if (pickSupport == null) {
            return false;
        }
        Point p = e.getPoint();
        this.selectedEdge = (VisualEdge)pickSupport.getEdge(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
        if (this.selectedEdge == null) {
            return false;
        }
        e.consume();
        this.isHandlingMouseEvents = true;
        return true;
    }

    protected boolean pickVertex(V vertex, VisualizationViewer<V, E> viewer) {
        PickedState pickedVertexState = viewer.getPickedVertexState();
        if (pickedVertexState == null) {
            return false;
        }
        if (!pickedVertexState.isPicked(vertex)) {
            pickedVertexState.clear();
            pickedVertexState.pick(vertex, true);
        }
        return true;
    }

    protected boolean pickEdge(E edge, VisualizationViewer<V, E> viewer) {
        PickedState pickedVertexState = viewer.getPickedEdgeState();
        if (pickedVertexState == null) {
            return false;
        }
        if (!pickedVertexState.isPicked(edge)) {
            pickedVertexState.clear();
            pickedVertexState.pick(edge, true);
        }
        return true;
    }

    protected boolean isOverVertex(MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        return GraphViewerUtils.getVertexFromPointInViewSpace(viewer, e.getPoint()) != null;
    }

    protected boolean isOverEdge(MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        VisualEdge edge = (VisualEdge)GraphViewerUtils.getEdgeFromPointInViewSpace(viewer, e.getPoint());
        if (edge == null) {
            return false;
        }
        return !this.isOverVertex(e);
    }

    protected void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        viewer.setCursor(newCursor);
    }

    protected boolean shouldShowCursor(MouseEvent e) {
        return this.isOverVertex(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        e.consume();
        this.resetState();
    }

    protected void resetState() {
        this.isHandlingMouseEvents = false;
        this.selectedVertex = null;
        this.selectedEdge = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        e.consume();
        this.resetState();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.installCursor(Cursor.getPredefinedCursor(0), e);
    }
}

