/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge.routing;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicEdgeRouter<V extends VisualVertex, E extends VisualEdge<V>> {
    protected VisualizationServer<V, E> viewer;
    protected Collection<E> edges = null;

    public BasicEdgeRouter(VisualizationServer<V, E> viewer, Collection<E> edges) {
        this.viewer = viewer;
        this.edges = edges;
    }

    public void route() {
        for (VisualEdge edge : this.edges) {
            List<Point2D> articulations = edge.getArticulationPoints();
            if (articulations.isEmpty()) continue;
            articulations = this.removeBadlyAngledArticulations(edge, articulations);
            edge.setArticulationPoints(articulations);
        }
    }

    protected boolean isOccluded(E edge, Shape graphSpaceShape) {
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        Collection vertices = graph.getVertices();
        for (VisualVertex vertex : vertices) {
            Rectangle vertexBounds = GraphViewerUtils.getVertexBoundsInGraphSpace(this.viewer, vertex);
            Pair endpoints = graph.getEndpoints(edge);
            if (vertex == endpoints.getFirst() || vertex == endpoints.getSecond() || !graphSpaceShape.intersects(vertexBounds)) continue;
            return true;
        }
        return false;
    }

    protected List<Point2D> removeBadlyAngledArticulations(E edge, List<Point2D> articulations) {
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        Pair endpoints = graph.getEndpoints(edge);
        VisualVertex start = (VisualVertex)endpoints.getFirst();
        VisualVertex end = (VisualVertex)endpoints.getSecond();
        Point2D startPoint = (Point2D)layout.apply((Object)start);
        Point2D endPoint = (Point2D)layout.apply((Object)end);
        if (startPoint.getY() > endPoint.getY()) {
            Point2D newStart = endPoint;
            endPoint = startPoint;
            startPoint = newStart;
        }
        ArrayList<Point2D> newList = new ArrayList<Point2D>();
        for (Point2D articulation : articulations) {
            double deltaX;
            double deltaY = articulation.getY() - startPoint.getY();
            double theta = Math.atan2(deltaY, deltaX = articulation.getX() - startPoint.getX());
            double degrees = theta * 180.0 / Math.PI;
            if (degrees < 0.0 || degrees > 180.0 || (degrees = (theta = Math.atan2(deltaY = endPoint.getY() - articulation.getY(), deltaX = endPoint.getX() - articulation.getX())) * 180.0 / Math.PI) < 0.0 || degrees > 180.0) continue;
            newList.add(articulation);
        }
        return newList;
    }
}

