/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import java.util.Map;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.SpringCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ContextScanRouteBuilderFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ContextScanRouteBuilderFinder.class);
    private final ApplicationContext applicationContext;
    private final PackageScanFilter filter;
    private final boolean includeNonSingletons;

    public ContextScanRouteBuilderFinder(SpringCamelContext camelContext, PackageScanFilter filter, boolean includeNonSingletons) {
        this.applicationContext = camelContext.getApplicationContext();
        this.filter = filter;
        this.includeNonSingletons = includeNonSingletons;
    }

    public void appendBuilders(List<RoutesBuilder> list) {
        Map<String, RoutesBuilder> beans = this.applicationContext.getBeansOfType(RoutesBuilder.class, this.includeNonSingletons, true);
        for (Map.Entry<String, RoutesBuilder> entry : beans.entrySet()) {
            RoutesBuilder bean = entry.getValue();
            String key = entry.getKey();
            LOG.trace("Found RouteBuilder with id: {} -> {}", (Object)key, (Object)bean);
            if (this.shouldIgnoreBean(bean)) {
                LOG.debug("Ignoring RouteBuilder id: {}", (Object)key);
                continue;
            }
            if (!this.isFilteredClass(bean)) {
                LOG.debug("Ignoring filtered RouteBuilder id: {} as class: {}", (Object)key, (Object)bean.getClass());
                continue;
            }
            LOG.debug("Adding instantiated RouteBuilder id: {} as class: {}", (Object)key, (Object)bean.getClass());
            list.add(bean);
        }
    }

    protected boolean shouldIgnoreBean(Object bean) {
        return false;
    }

    protected boolean isFilteredClass(Object bean) {
        if (this.filter != null) {
            return this.filter.matches(bean.getClass());
        }
        return false;
    }
}

