/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransportFilter;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.transport.tcp.SslTransportServer;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class StompSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    @Override
    protected SslTransportServer createSslTransportServer(URI location, SSLServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new SslTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new SslTransport(format2, (SSLSocket)socket){
                    private X509Certificate[] cachedPeerCerts;

                    @Override
                    public void doConsume(Object command) {
                        StompFrame frame = (StompFrame)command;
                        if (this.cachedPeerCerts == null) {
                            this.cachedPeerCerts = this.getPeerCertificates();
                        }
                        frame.setTransportContext(this.cachedPeerCerts);
                        super.doConsume(command);
                    }
                };
            }
        };
    }

    @Override
    public SslTransport createTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        return new SslTransport(wireFormat, (SSLSocket)socket, initBuffer){
            private X509Certificate[] cachedPeerCerts;

            @Override
            public void doConsume(Object command) {
                StompFrame frame = (StompFrame)command;
                if (this.cachedPeerCerts == null) {
                    this.cachedPeerCerts = this.getPeerCertificates();
                }
                frame.setTransportContext(this.cachedPeerCerts);
                super.doConsume(command);
            }
        };
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new StompTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        MutexTransport mutex = (transport = super.serverConfigure(transport, format2, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    protected Transport createInactivityMonitor(Transport transport, WireFormat format2) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format2);
        StompTransportFilter filter = transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

