/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb;

import java.io.File;
import java.io.IOException;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;

public class LevelDBStoreFactory
implements PersistenceAdapterFactory {
    private int asyncBufferSize = 0x400000;
    private File directory = new File("LevelDB");
    private int flushDelay = 5000;
    private int indexBlockRestartInterval = 16;
    private int indexBlockSize = 4096;
    private long indexCacheSize = 0x10000000L;
    private String indexCompression = "snappy";
    private String indexFactory = "org.fusesource.leveldbjni.JniDBFactory, org.iq80.leveldb.impl.Iq80DBFactory";
    private int indexMaxOpenFiles = 1000;
    private int indexWriteBufferSize = 0x600000;
    private String logCompression = "none";
    private File logDirectory;
    private long logSize = 0x6400000L;
    private boolean monitorStats;
    private boolean paranoidChecks;
    private boolean sync = true;
    private boolean verifyChecksums;

    public PersistenceAdapter createPersistenceAdapter() throws IOException {
        LevelDBStore store2 = new LevelDBStore();
        store2.setVerifyChecksums(this.verifyChecksums);
        store2.setAsyncBufferSize(this.asyncBufferSize);
        store2.setDirectory(this.directory);
        store2.setFlushDelay(this.flushDelay);
        store2.setIndexBlockRestartInterval(this.indexBlockRestartInterval);
        store2.setIndexBlockSize(this.indexBlockSize);
        store2.setIndexCacheSize(this.indexCacheSize);
        store2.setIndexCompression(this.indexCompression);
        store2.setIndexFactory(this.indexFactory);
        store2.setIndexMaxOpenFiles(this.indexMaxOpenFiles);
        store2.setIndexWriteBufferSize(this.indexWriteBufferSize);
        store2.setLogCompression(this.logCompression);
        store2.setLogDirectory(this.logDirectory);
        store2.setLogSize(this.logSize);
        store2.setMonitorStats(this.monitorStats);
        store2.setParanoidChecks(this.paranoidChecks);
        store2.setSync(this.sync);
        return store2;
    }

    public int getAsyncBufferSize() {
        return this.asyncBufferSize;
    }

    public void setAsyncBufferSize(int asyncBufferSize) {
        this.asyncBufferSize = asyncBufferSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public int getFlushDelay() {
        return this.flushDelay;
    }

    public void setFlushDelay(int flushDelay) {
        this.flushDelay = flushDelay;
    }

    public int getIndexBlockRestartInterval() {
        return this.indexBlockRestartInterval;
    }

    public void setIndexBlockRestartInterval(int indexBlockRestartInterval) {
        this.indexBlockRestartInterval = indexBlockRestartInterval;
    }

    public int getIndexBlockSize() {
        return this.indexBlockSize;
    }

    public void setIndexBlockSize(int indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
    }

    public long getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(long indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public String getIndexCompression() {
        return this.indexCompression;
    }

    public void setIndexCompression(String indexCompression) {
        this.indexCompression = indexCompression;
    }

    public String getIndexFactory() {
        return this.indexFactory;
    }

    public void setIndexFactory(String indexFactory) {
        this.indexFactory = indexFactory;
    }

    public int getIndexMaxOpenFiles() {
        return this.indexMaxOpenFiles;
    }

    public void setIndexMaxOpenFiles(int indexMaxOpenFiles) {
        this.indexMaxOpenFiles = indexMaxOpenFiles;
    }

    public int getIndexWriteBufferSize() {
        return this.indexWriteBufferSize;
    }

    public void setIndexWriteBufferSize(int indexWriteBufferSize) {
        this.indexWriteBufferSize = indexWriteBufferSize;
    }

    public String getLogCompression() {
        return this.logCompression;
    }

    public void setLogCompression(String logCompression) {
        this.logCompression = logCompression;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(File logDirectory2) {
        this.logDirectory = logDirectory2;
    }

    public long getLogSize() {
        return this.logSize;
    }

    public void setLogSize(long logSize) {
        this.logSize = logSize;
    }

    public boolean isMonitorStats() {
        return this.monitorStats;
    }

    public void setMonitorStats(boolean monitorStats2) {
        this.monitorStats = monitorStats2;
    }

    public boolean isParanoidChecks() {
        return this.paranoidChecks;
    }

    public void setParanoidChecks(boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isVerifyChecksums() {
        return this.verifyChecksums;
    }

    public void setVerifyChecksums(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }
}

