/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.util.IOHelper;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static String dumpModelAsXml(CamelContext context, NamedNode definition) throws JAXBException {
        JAXBContext jaxbContext = context == null ? ModelHelper.createJAXBContext() : context.getModelJAXBContextFactory().newJAXBContext();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, (Writer)buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NamedNode> T createModelFromXml(CamelContext context, String xml, Class<T> type) throws JAXBException {
        Object result;
        JAXBContext jaxbContext = context == null ? ModelHelper.createJAXBContext() : context.getModelJAXBContextFactory().newJAXBContext();
        StringReader reader = new StringReader(xml);
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            result = unmarshaller.unmarshal((Reader)reader);
        }
        finally {
            IOHelper.close((Closeable)reader);
        }
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to " + type + " using JAXB from XML: " + xml);
        }
        return (T)((NamedNode)type.cast(result));
    }

    public static <T extends NamedNode> T createModelFromXml(CamelContext context, InputStream stream, Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = context == null ? ModelHelper.createJAXBContext() : context.getModelJAXBContextFactory().newJAXBContext();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object result = unmarshaller.unmarshal(stream);
        return (T)((NamedNode)type.cast(result));
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest", (ClassLoader)CamelContext.class.getClassLoader());
    }
}

