/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

public class XMLTokenizeLanguage
extends LanguageSupport {
    private String path;
    private String headerName;
    private char mode;
    private int group;

    public static Expression tokenize(String path) {
        return XMLTokenizeLanguage.tokenize(path, 'i');
    }

    public static Expression tokenize(String path, char mode) {
        XMLTokenizeLanguage language = new XMLTokenizeLanguage();
        language.setPath(path);
        language.setMode(mode);
        return language.createExpression(null);
    }

    public static Expression tokenize(String headerName, String path) {
        return XMLTokenizeLanguage.tokenize(headerName, path, 'i');
    }

    public static Expression tokenize(String headerName, String path, char mode) {
        XMLTokenizeLanguage language = new XMLTokenizeLanguage();
        language.setHeaderName(headerName);
        language.setPath(path);
        language.setMode(mode);
        return language.createExpression(null);
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    public Expression createExpression() {
        ObjectHelper.notNull(this.path, "path");
        Expression answer = ExpressionBuilder.tokenizeXMLAwareExpression(this.path, this.mode);
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        if (ObjectHelper.isNotEmpty(expression)) {
            this.path = expression;
        }
        return this.createExpression();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public char getMode() {
        return this.mode;
    }

    public void setMode(char mode) {
        this.mode = mode;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}

