/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.lifecycle;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.linkedin.util.annotations.Initializable;
import org.linkedin.util.concurrent.WaitableCounter;
import org.linkedin.util.lifecycle.ShutdownRequestedException;
import org.linkedin.util.lifecycle.Shutdownable;

public class Shutdown
implements Serializable,
Shutdownable {
    private static final long serialVersionUID = 1L;
    private boolean _shutdown = false;
    @Initializable
    public WaitableCounter pendingCallsCount = new WaitableCounter();
    @Initializable
    public String module = Shutdown.class.getName();

    @Override
    public synchronized void shutdown() {
        this._shutdown = true;
    }

    @Override
    public void waitForShutdown() throws InterruptedException, IllegalStateException {
        if (!this._shutdown) {
            throw new IllegalStateException("call shutdown first");
        }
        this.pendingCallsCount.waitForCounter();
    }

    @Override
    public void waitForShutdown(Object timeout) throws InterruptedException, IllegalStateException, TimeoutException {
        if (!this._shutdown) {
            throw new IllegalStateException("call shutdown first");
        }
        this.pendingCallsCount.waitForCounter(timeout);
    }

    synchronized void startCall() throws ShutdownRequestedException {
        if (this._shutdown) {
            throw new ShutdownRequestedException(this.module);
        }
        this.pendingCallsCount.inc();
    }

    void endCall() {
        this.pendingCallsCount.dec();
    }

    public int getPendingCallsCount() {
        return this.pendingCallsCount.getCounter();
    }
}

