/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyStatement;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseServiceUtils;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createPackageBody", description="Creates a stored package body", priority=101, appliesTo={"packageBody"})
public class CreatePackageBodyChange
extends CreateProcedureChange {
    private String packageBodyName;
    private String packageBodyText;

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = LicenseServiceUtils.checkForValidLicense("Liquibase Pro", this);
        if (validationErrors.hasErrors()) {
            return validationErrors;
        }
        return super.validate(database);
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getPackageBodyName();
    }

    @Override
    public void setProcedureName(String string) {
        this.setPackageBodyName(string);
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getPackageBodyText();
    }

    @Override
    public void setProcedureText(String string) {
        this.setPackageBodyText(string);
    }

    @DatabaseChangeProperty(mustEqualExisting="packageBody", description="Name of the package body to drop")
    public String getPackageBodyName() {
        return this.packageBodyName;
    }

    public void setPackageBodyName(String string) {
        this.packageBodyName = string;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getPackageBodyText() {
        return this.packageBodyText;
    }

    public void setPackageBodyText(String string) {
        this.packageBodyText = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Package body " + this.getPackageBodyName() + " created";
    }

    @Override
    protected SqlStatement[] generateStatements(String string, String string2, Database database) {
        return new SqlStatement[]{new CreatePackageBodyStatement(this.getCatalogName(), this.getSchemaName(), this.getPackageBodyName(), string, string2)};
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

