/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class HaicomProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$GPRS").number("(d+),").expression("([^,]+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d)").number("(dd)(d{5})").number("(ddd)(d{5}),").number("(d+),").number("(d+),").number("(d+),").number("(d+)?,").number("(d+)?,").number("(d+),").number("(d+)").expression("(?:[LH]{2})?").number("#V(d+)").any().compile();

    public HaicomProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("versionFw", parser.next());
        position.setTime(parser.nextDateTime());
        int flags = parser.nextInt(0);
        position.setValid(BitUtil.check(flags, 0));
        double latitude = parser.nextDouble(0.0) + parser.nextDouble(0.0) / 60000.0;
        if (BitUtil.check(flags, 2)) {
            position.setLatitude(latitude);
        } else {
            position.setLatitude(-latitude);
        }
        double longitude = parser.nextDouble(0.0) + parser.nextDouble(0.0) / 60000.0;
        if (BitUtil.check(flags, 1)) {
            position.setLongitude(longitude);
        } else {
            position.setLongitude(-longitude);
        }
        position.setSpeed(parser.nextDouble(0.0) / 10.0);
        position.setCourse(parser.nextDouble(0.0) / 10.0);
        position.set("status", parser.next());
        position.set("gprsCount", parser.next());
        position.set("powersaveCountdown", parser.next());
        position.set("input", parser.next());
        position.set("output", parser.next());
        position.set("battery", parser.nextDouble(0.0) * 0.1);
        return position;
    }
}

