/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.LocationImpl;
import java.util.Vector;
import javax.xml.stream.Location;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LinkTagHandler
extends DefaultHandler {
    private final Report report;
    private Vector<LinkMarkup> linkTags = new Vector();
    private Locator locator;
    private int styleSheetsCount = 0;

    public LinkTagHandler(Report report) {
        this.report = report;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public int getStyleSheetsCount() {
        return this.styleSheetsCount;
    }

    public void checkForMultipleStyleSheets(String fileName) {
        LinkMarkup firstOne = null;
        for (LinkMarkup linkTag : this.linkTags) {
            if (linkTag.relAttribute.compareToIgnoreCase("stylesheet") == 0) {
                if (++this.styleSheetsCount == 1) {
                    firstOne = linkTag;
                } else if (this.styleSheetsCount > 1) {
                    if (firstOne != null) {
                        this.report.message(MessageId.CSS_012, EPUBLocation.create(fileName, firstOne.getLocation().getLineNumber(), firstOne.getLocation().getColumnNumber(), firstOne.getHrefAttribute()), new Object[0]);
                        firstOne = null;
                    }
                    this.report.message(MessageId.CSS_012, EPUBLocation.create(fileName, linkTag.getLocation().getLineNumber(), linkTag.getLocation().getColumnNumber(), linkTag.getHrefAttribute()), new Object[0]);
                }
            }
            if (linkTag.relAttribute.compareToIgnoreCase("alternate stylesheet") != 0) continue;
            String title = linkTag.getTitleAttribute();
            if (title == null || title.trim().equals("")) {
                this.report.message(MessageId.CSS_015, EPUBLocation.create(fileName, linkTag.getLocation().getLineNumber(), linkTag.getLocation().getColumnNumber(), linkTag.getHrefAttribute()), new Object[0]);
            }
            if (this.styleSheetsCount != 0) continue;
            this.report.message(MessageId.CSS_016, EPUBLocation.create(fileName, linkTag.getLocation().getLineNumber(), linkTag.getLocation().getColumnNumber(), linkTag.getHrefAttribute()), new Object[0]);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.compareToIgnoreCase("link") == 0) {
            LinkMarkup la = new LinkMarkup();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrName.compareToIgnoreCase("rel") == 0) {
                    la.setRelAttribute(attrValue);
                } else if (attrName.compareToIgnoreCase("type") == 0) {
                    la.setTypeAttribute(attrValue);
                } else if (attrName.compareToIgnoreCase("href") == 0) {
                    la.setHrefAttribute(attrValue);
                } else if (attrName.compareToIgnoreCase("class") == 0) {
                    la.setClassAttribute(attrValue);
                } else if (attrName.compareToIgnoreCase("title") == 0) {
                    la.setTitleAttribute(attrValue);
                }
                la.setLocation(new LocationImpl(this.locator.getLineNumber(), this.locator.getColumnNumber(), -1, this.locator.getPublicId(), this.locator.getSystemId()));
            }
            this.linkTags.add(la);
        }
    }

    class LinkMarkup {
        String relAttribute = "";
        String typeAttribute = "";
        String hrefAttribute = "";
        String classAttribute = "";
        String titleAttribute = "";
        Location location;

        LinkMarkup() {
        }

        public void setRelAttribute(String relAttribute) {
            this.relAttribute = relAttribute;
        }

        public void setTypeAttribute(String typeAttribute) {
            this.typeAttribute = typeAttribute;
        }

        public String getHrefAttribute() {
            return this.hrefAttribute;
        }

        public void setHrefAttribute(String hrefAttribute) {
            this.hrefAttribute = hrefAttribute;
        }

        public void setClassAttribute(String classAttribute) {
            this.classAttribute = classAttribute;
        }

        public String getTitleAttribute() {
            return this.titleAttribute;
        }

        public void setTitleAttribute(String value) {
            this.titleAttribute = value;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }
}

