/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeCreator;
import org.codehaus.xfire.aegis.type.TypeMapping;

public class CustomTypeMapping
implements TypeMapping {
    private static final Log LOG = LogFactory.getLog((Class)CustomTypeMapping.class);
    private Map class2Type = Collections.synchronizedMap(new HashMap());
    private Map xml2Type;
    private Map class2xml = Collections.synchronizedMap(new HashMap());
    private TypeMapping defaultTM;
    private String encodingStyleURI;
    private TypeCreator typeCreator;

    public CustomTypeMapping(TypeMapping defaultTM) {
        this();
        this.defaultTM = defaultTM;
    }

    public CustomTypeMapping() {
        this.xml2Type = Collections.synchronizedMap(new HashMap());
    }

    public boolean isRegistered(Class javaType) {
        boolean registered = this.class2Type.containsKey(javaType);
        if (!registered && this.defaultTM != null) {
            registered = this.defaultTM.isRegistered(javaType);
        }
        return registered;
    }

    public boolean isRegistered(QName xmlType) {
        boolean registered = this.xml2Type.containsKey(xmlType);
        if (!registered && this.defaultTM != null) {
            registered = this.defaultTM.isRegistered(xmlType);
        }
        return registered;
    }

    public void register(Class javaType, QName xmlType, Type type) {
        type.setSchemaType(xmlType);
        type.setTypeClass(javaType);
        this.register(type);
    }

    public void register(Type type) {
        type.setTypeMapping(this);
        if (type.getTypeClass() != null) {
            this.class2xml.put(type.getTypeClass(), type.getSchemaType());
            this.class2Type.put(type.getTypeClass(), type);
        }
        if (type.getSchemaType() != null) {
            this.xml2Type.put(type.getSchemaType(), type);
        }
        if (type.getTypeClass() == null && type.getSchemaType() == null) {
            LOG.warn((Object)("The type " + type.getClass().getName() + " supports neither serialization (non-null TypeClass) nor deserialization (non-null SchemaType)."));
        }
    }

    public void removeType(Type type) {
        if (!this.xml2Type.containsKey(type.getSchemaType())) {
            this.defaultTM.removeType(type);
        } else {
            this.xml2Type.remove(type.getSchemaType());
            this.class2Type.remove(type.getTypeClass());
            this.class2xml.remove(type.getTypeClass());
        }
    }

    public Type getType(Class javaType) {
        Type type = (Type)this.class2Type.get(javaType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(javaType);
        }
        return type;
    }

    public Type getType(QName xmlType) {
        Type type = (Type)this.xml2Type.get(xmlType);
        if (type == null && this.defaultTM != null) {
            type = this.defaultTM.getType(xmlType);
        }
        return type;
    }

    public QName getTypeQName(Class clazz) {
        QName qname = (QName)this.class2xml.get(clazz);
        if (qname == null && this.defaultTM != null) {
            qname = this.defaultTM.getTypeQName(clazz);
        }
        return qname;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public void setEncodingStyleURI(String encodingStyleURI) {
        this.encodingStyleURI = encodingStyleURI;
    }

    public TypeCreator getTypeCreator() {
        return this.typeCreator;
    }

    public void setTypeCreator(TypeCreator typeCreator) {
        this.typeCreator = typeCreator;
        typeCreator.setTypeMapping(this);
    }

    public TypeMapping getParent() {
        return this.defaultTM;
    }
}

