/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.util.HashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class PooledBrokerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    static final HashMap<String, SharedBroker> SHARED_BROKER_MAP = new HashMap();
    private boolean start;
    private Resource config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        HashMap<String, SharedBroker> hashMap = SHARED_BROKER_MAP;
        synchronized (hashMap) {
            SharedBroker sharedBroker = SHARED_BROKER_MAP.get(this.config.getFilename());
            if (sharedBroker == null) {
                sharedBroker = new SharedBroker();
                sharedBroker.factory = new BrokerFactoryBean();
                sharedBroker.factory.setConfig(this.config);
                sharedBroker.factory.setStart(this.start);
                sharedBroker.factory.afterPropertiesSet();
                SHARED_BROKER_MAP.put(this.config.getFilename(), sharedBroker);
            }
            ++sharedBroker.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        HashMap<String, SharedBroker> hashMap = SHARED_BROKER_MAP;
        synchronized (hashMap) {
            SharedBroker sharedBroker = SHARED_BROKER_MAP.get(this.config.getFilename());
            if (sharedBroker != null) {
                --sharedBroker.refCount;
                if (sharedBroker.refCount == 0) {
                    sharedBroker.factory.destroy();
                    SHARED_BROKER_MAP.remove(this.config.getFilename());
                }
            }
        }
    }

    public Resource getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        HashMap<String, SharedBroker> hashMap = SHARED_BROKER_MAP;
        synchronized (hashMap) {
            SharedBroker sharedBroker = SHARED_BROKER_MAP.get(this.config.getFilename());
            if (sharedBroker != null) {
                return sharedBroker.factory.getObject();
            }
        }
        return null;
    }

    public Class getObjectType() {
        return BrokerService.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    public void setStart(boolean start2) {
        this.start = start2;
    }

    static class SharedBroker {
        BrokerFactoryBean factory;
        int refCount;

        SharedBroker() {
        }
    }
}

