/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.subject;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.shiro.ConnectionReference;
import org.apache.activemq.shiro.subject.SubjectResolver;
import org.apache.activemq.shiro.subject.SubjectSecurityContext;
import org.apache.shiro.subject.Subject;

public class ConnectionSubjectResolver
implements SubjectResolver {
    private final SubjectSecurityContext securityContext;

    public ConnectionSubjectResolver(ConnectionContext connCtx) {
        if (connCtx == null) {
            throw new IllegalArgumentException("ConnectionContext argument cannot be null.");
        }
        SecurityContext secCtx = connCtx.getSecurityContext();
        if (secCtx == null) {
            String msg = "There is no SecurityContext available on the ConnectionContext.  It is expected that a previous broker in the chain will create the SecurityContext prior to this resolver being invoked.  Ensure you have configured the SubjectPlugin and that it is configured before all other Shiro-dependent broker filters.";
            throw new IllegalArgumentException(msg);
        }
        if (!(secCtx instanceof SubjectSecurityContext)) {
            String msg = "The specified SecurityContext is expected to be a " + SubjectSecurityContext.class.getName() + " instance.  The current instance's class: " + secCtx.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        this.securityContext = (SubjectSecurityContext)secCtx;
    }

    public ConnectionSubjectResolver(ConnectionReference conn) {
        this(conn.getConnectionContext());
    }

    @Override
    public Subject getSubject() {
        Subject subject = this.securityContext.getSubject();
        if (subject != null) {
            return subject;
        }
        String msg = "There is no Subject available in the SecurityContext.  Ensure that the SubjectPlugin is configured before all other Shiro-dependent broker filters.";
        throw new IllegalStateException(msg);
    }
}

