/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class TwoWayStream
extends Stream {
    public final Stream in;
    public final Stream out;
    private static final Primitive MAKE_TWO_WAY_STREAM = new Primitive(Symbol.MAKE_TWO_WAY_STREAM, "input-stream output-stream"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Stream in = Lisp.checkStream(first);
            Stream out = Lisp.checkStream(second);
            if (!in.isInputStream()) {
                return Lisp.type_error(in, Lisp.list(Symbol.SATISFIES, Symbol.INPUT_STREAM_P));
            }
            if (!out.isOutputStream()) {
                return Lisp.type_error(out, Lisp.list(Symbol.SATISFIES, Symbol.OUTPUT_STREAM_P));
            }
            return new TwoWayStream(in, out);
        }
    };
    private static final Primitive TWO_WAY_STREAM_INPUT_STREAM = new Primitive(Symbol.TWO_WAY_STREAM_INPUT_STREAM, "two-way-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof TwoWayStream) {
                return ((TwoWayStream)arg).in;
            }
            return Lisp.type_error(arg, Symbol.TWO_WAY_STREAM);
        }
    };
    private static final Primitive TWO_WAY_STREAM_OUTPUT_STREAM = new Primitive(Symbol.TWO_WAY_STREAM_OUTPUT_STREAM, "two-way-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof TwoWayStream) {
                return ((TwoWayStream)arg).out;
            }
            return Lisp.type_error(arg, Symbol.TWO_WAY_STREAM);
        }
    };

    public TwoWayStream(Stream in, Stream out) {
        super(Symbol.TWO_WAY_STREAM);
        this.in = in;
        this.out = out;
        this.isInputStream = true;
        this.isOutputStream = true;
    }

    public TwoWayStream(Stream in, Stream out, boolean interactive) {
        this(in, out);
        this.setInteractive(interactive);
    }

    @Override
    public LispObject getElementType() {
        LispObject otype;
        LispObject itype = this.in.getElementType();
        if (itype.equal(otype = this.out.getElementType())) {
            return itype;
        }
        return Lisp.list(Symbol.AND, itype, otype);
    }

    public Stream getInputStream() {
        return this.in;
    }

    public Stream getOutputStream() {
        return this.out;
    }

    @Override
    public boolean isCharacterInputStream() {
        return this.in.isCharacterInputStream();
    }

    @Override
    public boolean isBinaryInputStream() {
        return this.in.isBinaryInputStream();
    }

    @Override
    public boolean isCharacterOutputStream() {
        return this.out.isCharacterOutputStream();
    }

    @Override
    public boolean isBinaryOutputStream() {
        return this.out.isBinaryOutputStream();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.TWO_WAY_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.TWO_WAY_STREAM;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.TWO_WAY_STREAM) {
            return Lisp.T;
        }
        if (type == BuiltInClass.TWO_WAY_STREAM) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    protected int _readChar() throws IOException {
        return this.in._readChar();
    }

    @Override
    protected void _unreadChar(int n) throws IOException {
        this.in._unreadChar(n);
    }

    @Override
    protected boolean _charReady() throws IOException {
        return this.in._charReady();
    }

    @Override
    public void _writeChar(char c) {
        this.out._writeChar(c);
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        this.out._writeChars(chars, start, end);
    }

    @Override
    public void _writeString(String s) {
        this.out._writeString(s);
    }

    @Override
    public void _writeLine(String s) {
        this.out._writeLine(s);
    }

    @Override
    public int _readByte() {
        return this.in._readByte();
    }

    @Override
    public void _writeByte(int n) {
        this.out._writeByte(n);
    }

    @Override
    public void _finishOutput() {
        this.out._finishOutput();
    }

    @Override
    public void _clearInput() {
        this.in._clearInput();
    }

    @Override
    public LispObject listen() {
        return this.in.listen();
    }

    @Override
    public LispObject freshLine() {
        return this.out.freshLine();
    }

    @Override
    public LispObject close(LispObject abort) {
        this.setOpen(false);
        return Lisp.T;
    }

    @Override
    public String printObject() {
        return this.unreadableString("TWO-WAY-STREAM");
    }
}

