/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.IntegrityError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Load;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public class Autoload
extends Function {
    protected final String fileName;
    protected final String className;
    protected final Symbol symbol;
    public static final Primitive AUTOLOAD = new pf_autoload();
    public static final Primitive RESOLVE = new pf_resolve();
    public static final Primitive AUTOLOADP = new pf_autoloadp();

    protected Autoload(Symbol symbol) {
        this.fileName = null;
        this.className = null;
        this.symbol = symbol;
        symbol.setBuiltInFunction(false);
    }

    protected Autoload(Symbol symbol, String fileName, String className) {
        this.fileName = fileName;
        this.className = className;
        this.symbol = symbol;
        symbol.setBuiltInFunction(false);
    }

    protected final Symbol getSymbol() {
        return this.symbol;
    }

    public static void autoload(String symbolName, String className) {
        Autoload.autoload(Lisp.PACKAGE_CL, symbolName, className);
    }

    public static void autoload(Package pkg, String symbolName, String className) {
        Autoload.autoload(pkg, symbolName, className, false);
    }

    public static void autoload(Package pkg, String symbolName, String className, boolean exported) {
        Symbol symbol = Lisp.intern(symbolName.toUpperCase(), pkg);
        if (pkg != Lisp.PACKAGE_CL && exported) {
            pkg.export(symbol);
        }
        if (symbol.getSymbolFunction() == null) {
            symbol.setSymbolFunction(new Autoload(symbol, null, "org.armedbear.lisp.".concat(className)));
        }
    }

    public static void autoload(Symbol symbol, String className) {
        if (symbol.getSymbolFunction() == null) {
            symbol.setSymbolFunction(new Autoload(symbol, null, "org.armedbear.lisp.".concat(className)));
        }
    }

    private static void effectiveLoad(String className, String fileName) {
        if (className != null) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            Load.loadSystemFile(fileName, true);
        }
    }

    private static void loadVerbose(Symbol sym, int loadDepth, String className, String fileName) {
        String prefix = Load.getLoadVerbosePrefix(loadDepth);
        Stream out = Lisp.getStandardOutput();
        out._writeString(prefix);
        out._writeString(sym.getQualifiedName() + " triggers autoloading of ");
        out._writeString(className == null ? fileName : className);
        out._writeLine(" ...");
        out._finishOutput();
        long start = System.currentTimeMillis();
        Autoload.effectiveLoad(className, fileName);
        long elapsed = System.currentTimeMillis() - start;
        out._writeString(prefix);
        out._writeString(" Autoloaded ");
        out._writeString(className == null ? fileName : className);
        out._writeString(" (");
        out._writeString(String.valueOf((float)elapsed / 1000.0f));
        out._writeLine(" seconds)");
        out._finishOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        int loadDepth = Fixnum.getValue(Lisp._LOAD_DEPTH_.symbolValue());
        thread.bindSpecial(Lisp._LOAD_DEPTH_, Fixnum.getInstance(++loadDepth));
        try {
            if (Lisp._AUTOLOAD_VERBOSE_.symbolValue(thread) != Lisp.NIL || "Y".equals(System.getProperty("abcl.autoload.verbose"))) {
                Autoload.loadVerbose(this.symbol, loadDepth, this.className, this.getFileName());
            } else {
                Autoload.effectiveLoad(this.className, this.getFileName());
            }
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        if (this.symbol != null && this.symbol.getSymbolFunction() instanceof Autoload) {
            Debug.trace("Unable to autoload " + this.symbol.princToString());
            throw new IntegrityError();
        }
    }

    protected final String getFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return this.symbol.getName().toLowerCase();
    }

    @Override
    public LispObject execute() {
        this.load();
        return this.symbol.execute();
    }

    @Override
    public LispObject execute(LispObject arg) {
        this.load();
        return this.symbol.execute(arg);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        this.load();
        return this.symbol.execute(first, second);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        this.load();
        return this.symbol.execute(first, second, third);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
        this.load();
        return this.symbol.execute(first, second, third, fourth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth) {
        this.load();
        return this.symbol.execute(first, second, third, fourth, fifth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
        this.load();
        return this.symbol.execute(first, second, third, fourth, fifth, sixth);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh) {
        this.load();
        return this.symbol.execute(first, second, third, fourth, fifth, sixth, seventh);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth, LispObject seventh, LispObject eighth) {
        this.load();
        return this.symbol.execute(first, second, third, fourth, fifth, sixth, seventh, eighth);
    }

    @Override
    public LispObject execute(LispObject[] args) {
        this.load();
        return this.symbol.execute(args);
    }

    @Override
    public String printObject() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.symbol.princToString());
        sb.append(" stub to be autoloaded from \"");
        if (this.className != null) {
            int index = this.className.lastIndexOf(46);
            if (index >= 0) {
                sb.append(this.className.substring(index + 1));
            } else {
                sb.append(this.className);
            }
            sb.append(".class");
        } else {
            sb.append(this.getFileName());
        }
        sb.append("\"");
        return this.unreadableString(sb.toString());
    }

    static {
        Autoload.autoload("acos", "MathFunctions");
        Autoload.autoload("acosh", "MathFunctions");
        Autoload.autoload("arithmetic-error-operands", "ArithmeticError");
        Autoload.autoload("arithmetic-error-operation", "ArithmeticError");
        Autoload.autoload("ash", "ash");
        Autoload.autoload("asin", "MathFunctions");
        Autoload.autoload("asinh", "MathFunctions");
        Autoload.autoload("atan", "MathFunctions");
        Autoload.autoload("atanh", "MathFunctions");
        Autoload.autoload("broadcast-stream-streams", "BroadcastStream");
        Autoload.autoload("ceiling", "ceiling");
        Autoload.autoload("cell-error-name", "cell_error_name");
        Autoload.autoload("char", "StringFunctions");
        Autoload.autoload("char-equal", "CharacterFunctions");
        Autoload.autoload("char-greaterp", "CharacterFunctions");
        Autoload.autoload("char-lessp", "CharacterFunctions");
        Autoload.autoload("char-not-greaterp", "CharacterFunctions");
        Autoload.autoload("char-not-lessp", "CharacterFunctions");
        Autoload.autoload("char<", "CharacterFunctions");
        Autoload.autoload("char<=", "CharacterFunctions");
        Autoload.autoload("char=", "CharacterFunctions");
        Autoload.autoload("cis", "MathFunctions");
        Autoload.autoload("clrhash", "HashTableFunctions");
        Autoload.autoload("clrhash", "HashTableFunctions");
        Autoload.autoload("concatenated-stream-streams", "ConcatenatedStream");
        Autoload.autoload("cos", "MathFunctions");
        Autoload.autoload("cosh", "MathFunctions");
        Autoload.autoload("delete-file", "delete_file");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%delete-package", "PackageFunctions");
        Autoload.autoload("echo-stream-input-stream", "EchoStream");
        Autoload.autoload("echo-stream-output-stream", "EchoStream");
        Autoload.autoload("exp", "MathFunctions");
        Autoload.autoload("expt", "MathFunctions");
        Autoload.autoload("file-author", "file_author");
        Autoload.autoload("file-error-pathname", "file_error_pathname");
        Autoload.autoload("file-length", "file_length");
        Autoload.autoload("file-string-length", "file_string_length");
        Autoload.autoload("file-write-date", "file_write_date");
        Autoload.autoload("float", "FloatFunctions");
        Autoload.autoload("float-digits", "FloatFunctions");
        Autoload.autoload("float-radix", "FloatFunctions");
        Autoload.autoload("float-sign", "float_sign");
        Autoload.autoload("floatp", "FloatFunctions");
        Autoload.autoload("floor", "floor");
        Autoload.autoload("ftruncate", "ftruncate");
        Autoload.autoload("get-internal-real-time", "Time");
        Autoload.autoload("get-internal-run-time", "Time");
        Autoload.autoload("get-output-stream-string", "StringOutputStream");
        Autoload.autoload("get-properties", "get_properties");
        Autoload.autoload("get-universal-time", "Time");
        Autoload.autoload("gethash", "HashTableFunctions");
        Autoload.autoload("gethash", "HashTableFunctions");
        Autoload.autoload("hash-table-count", "HashTableFunctions");
        Autoload.autoload("hash-table-count", "HashTableFunctions");
        Autoload.autoload("hash-table-p", "HashTableFunctions");
        Autoload.autoload("hash-table-p", "HashTableFunctions");
        Autoload.autoload("hash-table-rehash-size", "HashTableFunctions");
        Autoload.autoload("hash-table-rehash-size", "HashTableFunctions");
        Autoload.autoload("hash-table-rehash-threshold", "HashTableFunctions");
        Autoload.autoload("hash-table-rehash-threshold", "HashTableFunctions");
        Autoload.autoload("hash-table-size", "HashTableFunctions");
        Autoload.autoload("hash-table-size", "HashTableFunctions");
        Autoload.autoload("hash-table-test", "HashTableFunctions");
        Autoload.autoload("hash-table-test", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%import", "PackageFunctions");
        Autoload.autoload("input-stream-p", "input_stream_p");
        Autoload.autoload("integer-decode-float", "FloatFunctions");
        Autoload.autoload("interactive-stream-p", "interactive_stream_p");
        Autoload.autoload("last", "last");
        Autoload.autoload("lisp-implementation-type", "lisp_implementation_type");
        Autoload.autoload("lisp-implementation-version", "lisp_implementation_version");
        Autoload.autoload("list-all-packages", "PackageFunctions");
        Autoload.autoload("listen", "listen");
        Autoload.autoload("log", "MathFunctions");
        Autoload.autoload("logand", "logand");
        Autoload.autoload("logandc1", "logandc1");
        Autoload.autoload("logandc2", "logandc2");
        Autoload.autoload("logbitp", "logbitp");
        Autoload.autoload("logcount", "logcount");
        Autoload.autoload("logeqv", "logeqv");
        Autoload.autoload("logior", "logior");
        Autoload.autoload("lognand", "lognand");
        Autoload.autoload("lognor", "lognor");
        Autoload.autoload("lognot", "lognot");
        Autoload.autoload("logorc1", "logorc1");
        Autoload.autoload("logorc2", "logorc2");
        Autoload.autoload("logtest", "logtest");
        Autoload.autoload("logxor", "logxor");
        Autoload.autoload("long-site-name", "SiteName");
        Autoload.autoload("machine-instance", "SiteName");
        Autoload.autoload("machine-type", "machine_type");
        Autoload.autoload("machine-version", "machine_version");
        Autoload.autoload("make-broadcast-stream", "BroadcastStream");
        Autoload.autoload("make-concatenated-stream", "ConcatenatedStream");
        Autoload.autoload("make-echo-stream", "EchoStream");
        Autoload.autoload("make-string-input-stream", "StringInputStream");
        Autoload.autoload("make-synonym-stream", "SynonymStream");
        Autoload.autoload("maphash", "HashTableFunctions");
        Autoload.autoload("mod", "mod");
        Autoload.autoload("open-stream-p", "open_stream_p");
        Autoload.autoload("output-stream-p", "output_stream_p");
        Autoload.autoload("package-error-package", "package_error_package");
        Autoload.autoload("package-error-package", "package_error_package");
        Autoload.autoload("package-name", "PackageFunctions");
        Autoload.autoload("package-nicknames", "PackageFunctions");
        Autoload.autoload("package-shadowing-symbols", "PackageFunctions");
        Autoload.autoload("package-use-list", "PackageFunctions");
        Autoload.autoload("package-used-by-list", "PackageFunctions");
        Autoload.autoload("packagep", "PackageFunctions");
        Autoload.autoload("peek-char", "peek_char");
        Autoload.autoload("print-not-readable-object", "PrintNotReadable");
        Autoload.autoload("probe-file", "probe_file");
        Autoload.autoload("rational", "FloatFunctions");
        Autoload.autoload("rem", "rem");
        Autoload.autoload("remhash", "HashTableFunctions");
        Autoload.autoload("remhash", "HashTableFunctions");
        Autoload.autoload("rename-package", "PackageFunctions");
        Autoload.autoload("room", "room");
        Autoload.autoload("scale-float", "FloatFunctions");
        Autoload.autoload("schar", "StringFunctions");
        Autoload.autoload("shadow", "PackageFunctions");
        Autoload.autoload("shadowing-import", "PackageFunctions");
        Autoload.autoload("short-site-name", "SiteName");
        Autoload.autoload("simple-condition-format-arguments", "SimpleCondition");
        Autoload.autoload("simple-condition-format-control", "SimpleCondition");
        Autoload.autoload("simple-string-p", "StringFunctions");
        Autoload.autoload("sin", "MathFunctions");
        Autoload.autoload("sinh", "MathFunctions");
        Autoload.autoload("software-type", "software_type");
        Autoload.autoload("software-version", "software_version");
        Autoload.autoload("sqrt", "MathFunctions");
        Autoload.autoload("stream-element-type", "stream_element_type");
        Autoload.autoload("stream-error-stream", "StreamError");
        Autoload.autoload("stream-external-format", "stream_external_format");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-stream-external-format", "Stream");
        Autoload.autoload("stringp", "StringFunctions");
        Autoload.autoload("sxhash", "HashTableFunctions");
        Autoload.autoload("sxhash", "HashTableFunctions");
        Autoload.autoload("synonym-stream-symbol", "SynonymStream");
        Autoload.autoload("tan", "MathFunctions");
        Autoload.autoload("tanh", "MathFunctions");
        Autoload.autoload("truename", "probe_file");
        Autoload.autoload("truncate", "truncate");
        Autoload.autoload("type-error-datum", "TypeError");
        Autoload.autoload("type-error-expected-type", "TypeError");
        Autoload.autoload("unbound-slot-instance", "unbound_slot_instance");
        Autoload.autoload("unexport", "PackageFunctions");
        Autoload.autoload("unuse-package", "PackageFunctions");
        Autoload.autoload(Lisp.PACKAGE_EXT, "arglist", "arglist", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "assq", "assq", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "assql", "assql", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "file-directory-p", "probe_file", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "gc", "gc", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "get-floating-point-modes", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "get-time-zone", "Time", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "make-slime-input-stream", "SlimeInputStream", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "make-slime-output-stream", "SlimeOutputStream", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "probe-directory", "probe_file", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "set-floating-point-modes", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "simple-string-fill", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_EXT, "simple-string-search", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_EXT, "string-input-stream-current", "StringInputStream", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "string-find", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_EXT, "string-position", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_EXT, "make-weak-reference", "WeakReference", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "weak-reference-value", "WeakReference", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "finalize", "Primitives", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "cancel-finalization", "Primitives", true);
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jnew-proxy", "JProxy");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%find-java-class", "JavaObject");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%register-java-class", "JavaObject");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jmake-invocation-handler", "JProxy");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jmake-proxy", "JProxy");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jnew-runtime-class", "RuntimeClass");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jredefine-method", "RuntimeClass");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jregister-handler", "JHandler");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%load-java-class-from-byte-array", "RuntimeClass");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "get-default-classloader", "JavaClassLoader");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "make-classloader", "JavaClassLoader");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%add-to-classpath", "JavaClassLoader");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "dump-classpath", "JavaClassLoader");
        Autoload.autoload(Lisp.PACKAGE_MOP, "eql-specializer-object", "EqualSpecializerObject", true);
        Autoload.autoload(Lisp.PACKAGE_MOP, "funcallable-instance-function", "FuncallableStandardObject", false);
        Autoload.autoload(Lisp.PACKAGE_MOP, "set-funcallable-instance-function", "FuncallableStandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_PROF, "%start-profiler", "Profiler", true);
        Autoload.autoload(Lisp.PACKAGE_PROF, "stop-profiler", "Profiler", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%%string=", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%adjust-array", "adjust_array");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%defpackage", "PackageFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%get-output-stream-bytes", "ByteArrayOutputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%get-output-stream-array", "ByteArrayOutputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-array", "make_array");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-byte-array-input-stream", "ByteArrayInputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-byte-array-output-stream", "ByteArrayOutputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-condition", "make_condition", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-emf-cache", "EMFCache", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-hash-table", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-hash-table", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-logical-pathname", "LogicalPathname", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-server-socket", "make_server_socket");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-socket", "make_socket");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-string", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-string-output-stream", "StringOutputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%nstring-capitalize", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%nstring-downcase", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%nstring-upcase", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%reinit-emf-cache", "EMFCache", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%run-shell-command", "ShellCommand");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%server-socket-close", "server_socket_close");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-arglist", "arglist");
        Autoload.autoload(Lisp.PACKAGE_CL, "find-class", "LispClass", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-find-class", "LispClass", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-class-direct-slots", "SlotClass", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-function-info", "function_info");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-symbol-macro", "Primitives");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-and", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-andc1", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-andc2", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-eqv", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-ior", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-nand", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-nor", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-not", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-orc1", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-orc2", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%simple-bit-vector-bit-xor", "SimpleBitVector");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%socket-accept", "socket_accept");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%socket-close", "socket_close");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%socket-stream", "socket_stream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-capitalize", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-downcase", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-equal", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-greaterp", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-lessp", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-not-equal", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-not-greaterp", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-not-lessp", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string-upcase", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string/=", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string<", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string<=", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string=", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string>", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%string>=", "StringFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%time", "Time");
        Autoload.autoload(Lisp.PACKAGE_SYS, "cache-emf", "EMFCache", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "canonicalize-logical-host", "LogicalPathname", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%class-direct-slots", "SlotClass");
        Autoload.autoload(Lisp.PACKAGE_SYS, "%float-bits", "FloatFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "coerce-to-double-float", "FloatFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "coerce-to-single-float", "FloatFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "create-new-file", "create_new_file");
        Autoload.autoload(Lisp.PACKAGE_SYS, "default-time-zone", "Time");
        Autoload.autoload(Lisp.PACKAGE_SYS, "disassemble-class-bytes", "disassemble_class_bytes", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "disable-zip-cache", "ZipCache", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "double-float-high-bits", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "double-float-low-bits", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "float-infinity-p", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "float-nan-p", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "float-string", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "function-info", "function_info");
        Autoload.autoload(Lisp.PACKAGE_SYS, "get-cached-emf", "EMFCache", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "get-function-info-value", "function_info");
        Autoload.autoload(Lisp.PACKAGE_SYS, "hash-table-entries", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "hash-table-entries", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "layout-class", "Layout", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "layout-length", "Layout", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "layout-slot-index", "Layout", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "layout-slot-location", "Layout", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-case-frob-stream", "CaseFrobStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-double-float", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-file-stream", "FileStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-fill-pointer-output-stream", "FillPointerOutputStream");
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-layout", "Layout", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-single-float", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%make-slot-definition", "SlotDefinition", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-structure-class", "StructureClass");
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-symbol-macro", "Primitives");
        Autoload.autoload(Lisp.PACKAGE_SYS, "psxhash", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "puthash", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "puthash", "HashTableFunctions");
        Autoload.autoload(Lisp.PACKAGE_SYS, "remove-zip-cache-entry", "ZipCache");
        Autoload.autoload(Lisp.PACKAGE_SYS, "set-function-info-value", "function_info");
        Autoload.autoload(Lisp.PACKAGE_SYS, "simple-list-remove-duplicates", "simple_list_remove_duplicates");
        Autoload.autoload(Lisp.PACKAGE_SYS, "single-float-bits", "FloatFunctions", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%std-allocate-instance", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "swap-slots", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "std-instance-layout", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-std-instance-layout", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "std-instance-class", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "standard-instance-access", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%set-standard-instance-access", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "std-slot-boundp", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "std-slot-value", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "set-std-slot-value", "StandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "%allocate-funcallable-instance", "FuncallableStandardObject", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "unzip", "unzip", true);
        Autoload.autoload(Lisp.PACKAGE_SYS, "zip", "zip", true);
        Autoload.autoload(Symbol.COPY_LIST, "copy_list");
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-fasl-class-loader", "FaslClassLoader", false);
        Autoload.autoload(Lisp.PACKAGE_SYS, "get-fasl-function", "FaslClassLoader", false);
        Autoload.autoload(Lisp.PACKAGE_SYS, "make-memory-class-loader", "MemoryClassLoader", false);
        Autoload.autoload(Lisp.PACKAGE_SYS, "put-memory-function", "MemoryClassLoader", false);
        Autoload.autoload(Lisp.PACKAGE_SYS, "get-memory-function", "MemoryClassLoader", false);
        Autoload.autoload(Symbol.SET_CHAR, "StringFunctions");
        Autoload.autoload(Symbol.SET_SCHAR, "StringFunctions");
        Autoload.autoload(Symbol._SET_CLASS_SLOTS, "SlotClass");
        Autoload.autoload(Symbol._CLASS_SLOTS, "SlotClass");
        Autoload.autoload(Symbol.JAVA_EXCEPTION_CAUSE, "JavaException");
        Autoload.autoload(Symbol.JCLASS_NAME, "jclass_name");
        Autoload.autoload(Symbol.JCLASS_OF, "jclass_of");
        Autoload.autoload(Symbol.JMETHOD_RETURN_TYPE, "jmethod_return_type");
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jget-property-value", "JavaBeans", false);
        Autoload.autoload(Lisp.PACKAGE_JAVA, "%jset-property-value", "JavaBeans", false);
        Autoload.autoload(Lisp.PACKAGE_EXT, "autoload-setf-expander", "AutoloadGeneralizedReference", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "autoload-setf-function", "AutoloadGeneralizedReference", true);
        Autoload.autoload(Lisp.PACKAGE_EXT, "autoload-ref-p", "AutoloadGeneralizedReference", true);
    }

    @DocString(name="autoloadp", args="symbol", doc="Boolean predicate for whether SYMBOL stands for a function that currently needs to be autoloaded.")
    private static final class pf_autoloadp
    extends Primitive {
        pf_autoloadp() {
            super("autoloadp", Lisp.PACKAGE_EXT, true, "symbol");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Symbol && arg.getSymbolFunction() instanceof Autoload) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="resolve", args="symbol", doc="Resolve the function named by SYMBOL via the autoloader mechanism.\nReturns either the function or NIL if no resolution was possible.")
    private static final class pf_resolve
    extends Primitive {
        pf_resolve() {
            super("resolve", Lisp.PACKAGE_EXT, true, "symbol");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Symbol symbol = Lisp.checkSymbol(arg);
            LispObject fun = symbol.getSymbolFunction();
            if (fun instanceof Autoload) {
                Autoload autoload = (Autoload)fun;
                autoload.load();
                return symbol.getSymbolFunction();
            }
            return fun == null ? Lisp.NIL : fun;
        }
    }

    @DocString(name="autoload", args="symbol-or-symbols &optional filename", doc="Setup the autoload for SYMBOL-OR-SYMBOLS optionally corresponding to FILENAME.")
    private static final class pf_autoload
    extends Primitive {
        pf_autoload() {
            super("autoload", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject first) {
            if (first instanceof Symbol) {
                Symbol symbol = (Symbol)first;
                symbol.setSymbolFunction(new Autoload(symbol));
                return Lisp.T;
            }
            if (first instanceof Cons) {
                for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                    Symbol symbol = Lisp.checkSymbol(list.car());
                    symbol.setSymbolFunction(new Autoload(symbol));
                }
                return Lisp.T;
            }
            return Lisp.error(new TypeError(first));
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            String fileName = second.getStringValue();
            if (first instanceof Symbol) {
                Symbol symbol = (Symbol)first;
                symbol.setSymbolFunction(new Autoload(symbol, fileName, null));
                return Lisp.T;
            }
            if (first instanceof Cons) {
                for (LispObject list = first; list != Lisp.NIL; list = list.cdr()) {
                    Symbol symbol = Lisp.checkSymbol(list.car());
                    symbol.setSymbolFunction(new Autoload(symbol, fileName, null));
                }
                return Lisp.T;
            }
            return Lisp.error(new TypeError(first));
        }
    }
}

