/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public final class InnerHitBuilder
extends ToXContentToBytes
implements Writeable {
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField IGNORE_UNMAPPED = new ParseField("ignore_unmapped", new String[0]);
    public static final QueryBuilder DEFAULT_INNER_HIT_QUERY = new MatchAllQueryBuilder();
    private static final ObjectParser<InnerHitBuilder, QueryParseContext> PARSER = new ObjectParser("inner_hits", InnerHitBuilder::new);
    private String name;
    private boolean ignoreUnmapped;
    private int from;
    private int size = 3;
    private boolean explain;
    private boolean version;
    private boolean trackScores;
    private StoredFieldsContext storedFieldsContext;
    private QueryBuilder query = DEFAULT_INNER_HIT_QUERY;
    private List<SortBuilder<?>> sorts;
    private List<String> docValueFields;
    private Set<SearchSourceBuilder.ScriptField> scriptFields;
    private HighlightBuilder highlightBuilder;
    private FetchSourceContext fetchSourceContext;

    public InnerHitBuilder() {
        this.name = null;
    }

    public InnerHitBuilder(String name) {
        this.name = name;
    }

    public InnerHitBuilder(StreamInput in) throws IOException {
        int i;
        int size;
        this.name = in.readOptionalString();
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readOptionalString();
            in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_5_2_0)) {
            this.ignoreUnmapped = in.readBoolean();
        }
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.explain = in.readBoolean();
        this.version = in.readBoolean();
        this.trackScores = in.readBoolean();
        this.storedFieldsContext = in.readOptionalWriteable(StoredFieldsContext::new);
        this.docValueFields = (List)in.readGenericValue();
        if (in.readBoolean()) {
            size = in.readVInt();
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>(size);
            for (i = 0; i < size; ++i) {
                this.scriptFields.add(new SearchSourceBuilder.ScriptField(in));
            }
        }
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        if (in.readBoolean()) {
            size = in.readVInt();
            this.sorts = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                this.sorts.add(in.readNamedWriteable(SortBuilder.class));
            }
        }
        this.highlightBuilder = in.readOptionalWriteable(HighlightBuilder::new);
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readNamedWriteable(QueryBuilder.class);
            boolean hasChildren = in.readBoolean();
            assert (!hasChildren);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_5_5_0)) {
            throw new IOException("Invalid output version, must >= " + Version.V_5_5_0.toString());
        }
        out.writeOptionalString(this.name);
        out.writeBoolean(this.ignoreUnmapped);
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.version);
        out.writeBoolean(this.trackScores);
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeGenericValue(this.docValueFields);
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeVInt(this.scriptFields.size());
            Iterator iterator = this.scriptFields.stream().sorted(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName)).iterator();
            while (iterator.hasNext()) {
                ((SearchSourceBuilder.ScriptField)iterator.next()).writeTo(out);
            }
        }
        out.writeOptionalWriteable(this.fetchSourceContext);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeVInt(this.sorts.size());
            for (SortBuilder<?> sort : this.sorts) {
                out.writeNamedWriteable(sort);
            }
        }
        out.writeOptionalWriteable(this.highlightBuilder);
    }

    protected void writeToNestedBWC(StreamOutput out, QueryBuilder query, String nestedPath) throws IOException {
        assert (out.getVersion().before(Version.V_5_5_0)) : "invalid output version, must be < " + Version.V_5_5_0.toString();
        this.writeToBWC(out, query, nestedPath, null);
    }

    public void writeToCollapseBWC(StreamOutput out) throws IOException {
        assert (out.getVersion().before(Version.V_5_5_0)) : "invalid output version, must be < " + Version.V_5_5_0.toString();
        this.writeToBWC(out, new MatchAllQueryBuilder(), null, null);
    }

    public void writeToParentChildBWC(StreamOutput out, QueryBuilder query, String parentChildPath) throws IOException {
        assert (out.getVersion().before(Version.V_5_5_0)) : "invalid output version, must be < " + Version.V_5_5_0.toString();
        this.writeToBWC(out, query, null, parentChildPath);
    }

    private void writeToBWC(StreamOutput out, QueryBuilder query, String nestedPath, String parentChildPath) throws IOException {
        out.writeOptionalString(this.name);
        if (nestedPath != null) {
            out.writeOptionalString(nestedPath);
            out.writeOptionalString(null);
        } else {
            out.writeOptionalString(null);
            out.writeOptionalString(parentChildPath);
        }
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeBoolean(this.ignoreUnmapped);
        }
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        out.writeBoolean(this.explain);
        out.writeBoolean(this.version);
        out.writeBoolean(this.trackScores);
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeGenericValue(this.docValueFields);
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeVInt(this.scriptFields.size());
            Iterator iterator = this.scriptFields.stream().sorted(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName)).iterator();
            while (iterator.hasNext()) {
                ((SearchSourceBuilder.ScriptField)iterator.next()).writeTo(out);
            }
        }
        out.writeOptionalWriteable(this.fetchSourceContext);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeVInt(this.sorts.size());
            for (SortBuilder<?> sort : this.sorts) {
                out.writeNamedWriteable(sort);
            }
        }
        out.writeOptionalWriteable(this.highlightBuilder);
        out.writeNamedWriteable(query);
        out.writeBoolean(false);
    }

    public String getName() {
        return this.name;
    }

    public InnerHitBuilder setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public InnerHitBuilder setIgnoreUnmapped(boolean value) {
        this.ignoreUnmapped = value;
        return this;
    }

    public boolean isIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public int getFrom() {
        return this.from;
    }

    public InnerHitBuilder setFrom(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("illegal from value, at least 0 or higher");
        }
        this.from = from;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public InnerHitBuilder setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("illegal size value, at least 0 or higher");
        }
        this.size = size;
        return this;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public InnerHitBuilder setExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean isVersion() {
        return this.version;
    }

    public InnerHitBuilder setVersion(boolean version) {
        this.version = version;
        return this;
    }

    public boolean isTrackScores() {
        return this.trackScores;
    }

    public InnerHitBuilder setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Deprecated
    public List<String> getFieldNames() {
        return this.storedFieldsContext == null ? null : this.storedFieldsContext.fieldNames();
    }

    @Deprecated
    public InnerHitBuilder setFieldNames(List<String> fieldNames) {
        return this.setStoredFieldNames(fieldNames);
    }

    public StoredFieldsContext getStoredFieldsContext() {
        return this.storedFieldsContext;
    }

    public InnerHitBuilder setStoredFieldNames(List<String> fieldNames) {
        if (this.storedFieldsContext == null) {
            this.storedFieldsContext = StoredFieldsContext.fromList(fieldNames);
        } else {
            this.storedFieldsContext.addFieldNames(fieldNames);
        }
        return this;
    }

    @Deprecated
    public List<String> getFieldDataFields() {
        return this.docValueFields;
    }

    @Deprecated
    public InnerHitBuilder setFieldDataFields(List<String> fieldDataFields) {
        this.docValueFields = fieldDataFields;
        return this;
    }

    @Deprecated
    public InnerHitBuilder addFieldDataField(String field) {
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<String>();
        }
        this.docValueFields.add(field);
        return this;
    }

    public List<String> getDocValueFields() {
        return this.docValueFields;
    }

    public InnerHitBuilder setDocValueFields(List<String> docValueFields) {
        this.docValueFields = docValueFields;
        return this;
    }

    public InnerHitBuilder addDocValueField(String field) {
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<String>();
        }
        this.docValueFields.add(field);
        return this;
    }

    public Set<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields;
    }

    public InnerHitBuilder setScriptFields(Set<SearchSourceBuilder.ScriptField> scriptFields) {
        this.scriptFields = scriptFields;
        return this;
    }

    public InnerHitBuilder addScriptField(String name, Script script) {
        if (this.scriptFields == null) {
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
        }
        this.scriptFields.add(new SearchSourceBuilder.ScriptField(name, script, false));
        return this;
    }

    public FetchSourceContext getFetchSourceContext() {
        return this.fetchSourceContext;
    }

    public InnerHitBuilder setFetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public List<SortBuilder<?>> getSorts() {
        return this.sorts;
    }

    public InnerHitBuilder setSorts(List<SortBuilder<?>> sorts) {
        this.sorts = sorts;
        return this;
    }

    public InnerHitBuilder addSort(SortBuilder<?> sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public HighlightBuilder getHighlightBuilder() {
        return this.highlightBuilder;
    }

    public InnerHitBuilder setHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    QueryBuilder getQuery() {
        return this.query;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        builder.field(IGNORE_UNMAPPED.getPreferredName(), this.ignoreUnmapped);
        builder.field(SearchSourceBuilder.FROM_FIELD.getPreferredName(), this.from);
        builder.field(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), this.size);
        builder.field(SearchSourceBuilder.VERSION_FIELD.getPreferredName(), this.version);
        builder.field(SearchSourceBuilder.EXPLAIN_FIELD.getPreferredName(), this.explain);
        builder.field(SearchSourceBuilder.TRACK_SCORES_FIELD.getPreferredName(), this.trackScores);
        if (this.fetchSourceContext != null) {
            builder.field(SearchSourceBuilder._SOURCE_FIELD.getPreferredName(), this.fetchSourceContext, params);
        }
        if (this.storedFieldsContext != null) {
            this.storedFieldsContext.toXContent(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), builder);
        }
        if (this.docValueFields != null) {
            builder.startArray(SearchSourceBuilder.DOCVALUE_FIELDS_FIELD.getPreferredName());
            for (String string : this.docValueFields) {
                builder.value(string);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject(SearchSourceBuilder.SCRIPT_FIELDS_FIELD.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
            for (SortBuilder sortBuilder : this.sorts) {
                sortBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.highlightBuilder != null) {
            builder.field(SearchSourceBuilder.HIGHLIGHT_FIELD.getPreferredName(), this.highlightBuilder, params);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InnerHitBuilder that = (InnerHitBuilder)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped) && Objects.equals(this.from, that.from) && Objects.equals(this.size, that.size) && Objects.equals(this.explain, that.explain) && Objects.equals(this.version, that.version) && Objects.equals(this.trackScores, that.trackScores) && Objects.equals(this.storedFieldsContext, that.storedFieldsContext) && Objects.equals(this.docValueFields, that.docValueFields) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.fetchSourceContext, that.fetchSourceContext) && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.highlightBuilder, that.highlightBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ignoreUnmapped, this.from, this.size, this.explain, this.version, this.trackScores, this.storedFieldsContext, this.docValueFields, this.scriptFields, this.fetchSourceContext, this.sorts, this.highlightBuilder);
    }

    public static InnerHitBuilder fromXContent(QueryParseContext context) throws IOException {
        return PARSER.parse(context.parser(), new InnerHitBuilder(), context);
    }

    static {
        PARSER.declareString(InnerHitBuilder::setName, NAME_FIELD);
        PARSER.declareBoolean((innerHitBuilder, value) -> {
            innerHitBuilder.ignoreUnmapped = value;
        }, IGNORE_UNMAPPED);
        PARSER.declareInt(InnerHitBuilder::setFrom, SearchSourceBuilder.FROM_FIELD);
        PARSER.declareInt(InnerHitBuilder::setSize, SearchSourceBuilder.SIZE_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setExplain, SearchSourceBuilder.EXPLAIN_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setVersion, SearchSourceBuilder.VERSION_FIELD);
        PARSER.declareBoolean(InnerHitBuilder::setTrackScores, SearchSourceBuilder.TRACK_SCORES_FIELD);
        PARSER.declareStringArray(InnerHitBuilder::setStoredFieldNames, SearchSourceBuilder.STORED_FIELDS_FIELD);
        PARSER.declareField((p, i, c) -> {
            throw new ParsingException(p.getTokenLocation(), "The field [" + SearchSourceBuilder.FIELDS_FIELD + "] is no longer supported, please use [" + SearchSourceBuilder.STORED_FIELDS_FIELD + "] to retrieve stored fields or _source filtering if the field is not stored", new Object[0]);
        }, SearchSourceBuilder.FIELDS_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareStringArray(InnerHitBuilder::setDocValueFields, SearchSourceBuilder.DOCVALUE_FIELDS_FIELD);
        PARSER.declareField((p, i, c) -> {
            try {
                HashSet<SearchSourceBuilder.ScriptField> scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
                XContentParser.Token token = p.nextToken();
                while (token != XContentParser.Token.END_OBJECT) {
                    scriptFields.add(new SearchSourceBuilder.ScriptField((QueryParseContext)c));
                    token = p.nextToken();
                }
                i.setScriptFields(scriptFields);
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "Could not parse inner script definition", e, new Object[0]);
            }
        }, SearchSourceBuilder.SCRIPT_FIELDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((p, i, c) -> i.setSorts(SortBuilder.fromXContent(c)), SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((p, i, c) -> {
            try {
                i.setFetchSourceContext(FetchSourceContext.fromXContent(c.parser()));
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "Could not parse inner _source definition", e, new Object[0]);
            }
        }, SearchSourceBuilder._SOURCE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareObject(InnerHitBuilder::setHighlightBuilder, (p, c) -> HighlightBuilder.fromXContent(c), SearchSourceBuilder.HIGHLIGHT_FIELD);
    }
}

