/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.transport.ConnectTransportException;

abstract class InitialSearchPhase<FirstResult extends SearchPhaseResult>
extends SearchPhase {
    private final SearchRequest request;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;
    private final Logger logger;
    private final int expectedTotalOps;
    private final AtomicInteger totalOps = new AtomicInteger();

    InitialSearchPhase(String name, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts, Logger logger) {
        super(name);
        this.request = request;
        this.shardsIts = shardsIts;
        this.logger = logger;
        this.expectedTotalOps = shardsIts.totalSizeWith1ForEmpty();
    }

    private void onShardFailure(int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, SearchShardIterator shardIt, Exception e) {
        SearchShardTarget shardTarget = new SearchShardTarget(nodeId, shardIt.shardId(), shardIt.getClusterAlias(), shardIt.getOriginalIndices());
        this.onShardFailure(shardIndex, shardTarget, e);
        if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
            if (this.logger.isDebugEnabled()) {
                if (e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), (Object)this.request), (Throwable)e);
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}]", (Object)shard, (Object)this.request), (Throwable)e);
                }
            }
            this.onPhaseDone();
        } else {
            ShardRouting nextShard = shardIt.nextOrNull();
            boolean lastShard = nextShard == null;
            this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard}), (Throwable)e);
            if (!lastShard) {
                try {
                    this.performPhaseOnShard(shardIndex, shardIt, nextShard);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, inner);
                }
            } else if (this.logger.isDebugEnabled() && !this.logger.isTraceEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                this.logger.debug(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard}), (Throwable)e);
            }
        }
    }

    @Override
    public final void run() throws IOException {
        int shardIndex = -1;
        for (SearchShardIterator shardIt : this.shardsIts) {
            ++shardIndex;
            ShardRouting shard = shardIt.nextOrNull();
            if (shard != null) {
                this.performPhaseOnShard(shardIndex, shardIt, shard);
                continue;
            }
            this.onShardFailure(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        }
    }

    private void performPhaseOnShard(final int shardIndex, final SearchShardIterator shardIt, final ShardRouting shard) {
        if (shard == null) {
            this.onShardFailure(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        } else {
            try {
                this.executePhaseOnShard(shardIt, shard, new SearchActionListener<FirstResult>(new SearchShardTarget(shard.currentNodeId(), shardIt.shardId(), shardIt.getClusterAlias(), shardIt.getOriginalIndices()), shardIndex){

                    @Override
                    public void innerOnResponse(FirstResult result) {
                        InitialSearchPhase.this.onShardResult(result, shardIt);
                    }

                    @Override
                    public void onFailure(Exception t) {
                        InitialSearchPhase.this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, t);
                    }
                });
            }
            catch (IllegalArgumentException | ConnectTransportException ex) {
                this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, ex);
            }
        }
    }

    private void onShardResult(FirstResult result, ShardIterator shardIt) {
        assert (((SearchPhaseResult)result).getShardIndex() != -1) : "shard index is not set";
        assert (((SearchPhaseResult)result).getSearchShardTarget() != null) : "search shard target must not be null";
        this.onShardSuccess(result);
        int xTotalOps = this.totalOps.addAndGet(shardIt.remaining() + 1);
        if (xTotalOps == this.expectedTotalOps) {
            this.onPhaseDone();
        } else if (xTotalOps > this.expectedTotalOps) {
            throw new AssertionError((Object)("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]"));
        }
    }

    abstract void onPhaseDone();

    abstract void onShardFailure(int var1, SearchShardTarget var2, Exception var3);

    abstract void onShardSuccess(FirstResult var1);

    protected abstract void executePhaseOnShard(SearchShardIterator var1, ShardRouting var2, SearchActionListener<FirstResult> var3);

    static class SearchPhaseResults<Result extends SearchPhaseResult> {
        final AtomicArray<Result> results;

        SearchPhaseResults(int size) {
            this.results = new AtomicArray(size);
        }

        final int getNumShards() {
            return this.results.length();
        }

        final Stream<Result> getSuccessfulResults() {
            return this.results.asList().stream();
        }

        void consumeResult(Result result) {
            assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
            this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        }

        final boolean hasResult(int shardIndex) {
            return this.results.get(shardIndex) != null;
        }

        SearchPhaseController.ReducedQueryPhase reduce() {
            throw new UnsupportedOperationException("reduce is not supported");
        }
    }
}

