/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsErrorFunction
implements Function {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 5692502042198617868L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            Type type = parameters.getType(0);
            Object value = parameters.getValue(0);
            if (ErrorType.TYPE.equals(type) && value instanceof ErrorValue) {
                return RETURN_TRUE;
            }
        }
        catch (EvaluationException e) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    public String getCanonicalName() {
        return "ISERROR";
    }
}

