/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.cols.AbstractColumnModel;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;

public class SpearateColumnModel
extends AbstractColumnModel {
    private long validationTrack;
    private long preferredSize;
    private long maxBoxSize;
    private long minimumChunkSize;
    private long borderSpacing;

    public void validateSizes(TableRenderBox tableRenderBox) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        int n;
        long l7;
        Object object;
        if (this.isValidated() && this.validationTrack == tableRenderBox.getChangeTracker()) {
            return;
        }
        int n2 = 0;
        TableColumn[] tableColumnArray = this.getColumns();
        int n3 = tableColumnArray.length;
        for (int i = 0; i < n3; ++i) {
            object = tableColumnArray[i];
            int n4 = ((TableColumn)object).getMaxColspan();
            if (n4 <= n2) continue;
            n2 = n4;
        }
        if (n3 == 0) {
            this.validationTrack = tableRenderBox.getChangeTracker();
            return;
        }
        ComputedLayoutProperties computedLayoutProperties = tableRenderBox.getComputedLayoutProperties();
        object = computedLayoutProperties.getBlockContextWidth();
        long l8 = ((RenderLength)object).resolve(0L);
        RenderLength renderLength = tableRenderBox.getBorderSpacing();
        this.borderSpacing = renderLength.resolve(l8);
        this.minimumChunkSize = l7 = (long)(n3 - 1) * this.borderSpacing;
        this.maxBoxSize = l7;
        this.preferredSize = l7;
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        long[] lArray3 = new long[n3];
        for (n = 0; n < lArray.length; ++n) {
            TableColumn tableColumn = tableColumnArray[n];
            l6 = tableColumn.getMinimumChunkSize(1);
            l5 = tableColumn.getMaximumBoxWidth(1);
            l4 = tableColumn.getDefinedWidth().resolve(l8);
            l3 = Math.max(l4, tableColumn.getPreferredWidth(1));
            lArray[n] = l6;
            lArray2[n] = l5;
            lArray3[n] = l3;
        }
        for (n = 2; n <= n2; ++n) {
            for (int i = 0; i < lArray.length; ++i) {
                TableColumn tableColumn = tableColumnArray[i];
                l2 = tableColumn.getMinimumChunkSize(n);
                l = tableColumn.getMaximumBoxWidth(n);
                long l9 = tableColumn.getPreferredWidth(n);
                this.distribute(l2, lArray, i, n);
                this.distribute(l9, lArray3, i, n);
                this.distribute(l, lArray2, i, n);
            }
        }
        for (n = 0; n < lArray.length; ++n) {
            TableColumn tableColumn = tableColumnArray[n];
            l6 = lArray[n];
            l5 = lArray3[n];
            l4 = lArray2[n];
            l3 = Math.max(l6, l5);
            this.minimumChunkSize += l6;
            this.preferredSize += l3;
            this.maxBoxSize += l4;
            if (tableColumn.isValidated()) continue;
            tableColumn.setComputedPreferredSize(l5);
            tableColumn.setComputedMinChunkSize(l6);
            tableColumn.setComputedMaximumWidth(l4);
            tableColumn.setEffectiveSize(l3);
            tableColumn.setValidated(true);
        }
        RenderLength renderLength2 = tableRenderBox.getComputedLayoutProperties().getComputedWidth();
        if (renderLength2 != RenderLength.AUTO) {
            long l10 = Math.max(renderLength2.resolve(0L), this.minimumChunkSize);
            l2 = l10 - this.preferredSize;
            l = l2 / (long)lArray.length;
            for (int i = 0; i < lArray.length; ++i) {
                TableColumn tableColumn = tableColumnArray[i];
                long l11 = tableColumn.getEffectiveSize() + l;
                tableColumn.setEffectiveSize(l11);
            }
            this.preferredSize = l10;
        }
        this.validationTrack = tableRenderBox.getChangeTracker();
    }

    public long getPreferredSize() {
        return this.preferredSize;
    }

    public long getMaximumBoxSize() {
        return this.maxBoxSize;
    }

    public long getMinimumChunkSize() {
        return this.minimumChunkSize;
    }

    private void distribute(long l, long[] lArray, int n, int n2) {
        int n3 = Math.min(n + n2, lArray.length) - n;
        int n4 = Math.min(lArray.length, n + n3);
        long l2 = 0L;
        for (int i = n; i < n4; ++i) {
            l2 += lArray[i];
        }
        if (l <= l2) {
            return;
        }
        long l3 = l - l2;
        long l4 = l3 / (long)n3;
        for (int i = 0; i < n3 - 1; ++i) {
            lArray[n + i] = l4;
        }
        lArray[n + n3 - 1] = l3 - (long)(n3 - 1) * l4;
    }

    public long getBorderSpacing() {
        return this.borderSpacing;
    }
}

