/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.draw.TransformRestoreEdit;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGImageFigure
extends SVGAttributedFigure
implements SVGFigure,
ImageHolderFigure {
    private Rectangle2D.Double rectangle;
    private transient Shape cachedTransformedShape;
    private transient Shape cachedHitShape;
    private byte[] imageData;
    private BufferedImage bufferedImage;

    public SVGImageFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGImageFigure(double d, double d2, double d3, double d4) {
        this.rectangle = new Rectangle2D.Double(d, d2, d3, d4);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        double d = this.get(SVGAttributeKeys.OPACITY);
        if ((d = Math.min(Math.max(0.0, d), 1.0)) != 0.0) {
            BufferedImage bufferedImage;
            Composite composite = graphics2D.getComposite();
            if (d != 1.0) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
            }
            if ((bufferedImage = this.getBufferedImage()) != null) {
                if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                    Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                    graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
                    graphics2D2.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
                    graphics2D2.drawImage(bufferedImage, (int)this.rectangle.x, (int)this.rectangle.y, (int)this.rectangle.width, (int)this.rectangle.height, null);
                    graphics2D2.dispose();
                } else {
                    graphics2D.drawImage(bufferedImage, (int)this.rectangle.x, (int)this.rectangle.y, (int)this.rectangle.width, (int)this.rectangle.height, null);
                }
            } else {
                Shape shape = this.getTransformedShape();
                graphics2D.setColor(Color.red);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.draw(shape);
            }
            if (d != 1.0) {
                graphics2D.setComposite(composite);
            }
        }
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
    }

    public double getX() {
        return this.rectangle.x;
    }

    public double getY() {
        return this.rectangle.y;
    }

    public double getWidth() {
        return this.rectangle.width;
    }

    public double getHeight() {
        return this.rectangle.height;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.rectangle.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D rectangle2D = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_ = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        return double_;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        return this.getHitShape().contains(double_);
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.invalidateTransformedShape();
        this.rectangle.x = Math.min(double_.x, double_2.x);
        this.rectangle.y = Math.min(double_.y, double_2.y);
        this.rectangle.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.rectangle.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    private void invalidateTransformedShape() {
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = (Shape)this.rectangle.clone();
            if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
                this.cachedTransformedShape = ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(this.cachedTransformedShape);
            }
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.invalidateTransformedShape();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 7) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)affineTransform.clone());
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            Point2D.Double double_ = this.getStartPoint();
            Point2D.Double double_2 = this.getEndPoint();
            this.setBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
        }
    }

    @Override
    public void restoreTransformTo(Object object) {
        this.invalidateTransformedShape();
        Object[] objectArray = (Object[])object;
        this.rectangle = (Rectangle2D.Double)((Rectangle2D.Double)objectArray[0]).clone();
        if (objectArray[1] == null) {
            this.set(SVGAttributeKeys.TRANSFORM, null);
        } else {
            this.set(SVGAttributeKeys.TRANSFORM, (AffineTransform)((AffineTransform)objectArray[1]).clone());
        }
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.rectangle.clone(), this.get(SVGAttributeKeys.TRANSFORM)};
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, linkedList);
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> linkedList = new LinkedList<Action>();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVGImageFigure.this.willChange();
                    SVGImageFigure.this.fireUndoableEditHappened(SVGAttributeKeys.TRANSFORM.setUndoable(SVGImageFigure.this, null));
                    SVGImageFigure.this.changed();
                }
            });
        }
        if (this.bufferedImage != null) {
            double d;
            double d2;
            if (this.rectangle.width != (double)this.bufferedImage.getWidth() || this.rectangle.height != (double)this.bufferedImage.getHeight()) {
                linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.setToImageSize.text")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x - ((double)SVGImageFigure.this.bufferedImage.getWidth() - ((SVGImageFigure)SVGImageFigure.this).rectangle.width) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.y - ((double)SVGImageFigure.this.bufferedImage.getHeight() - ((SVGImageFigure)SVGImageFigure.this).rectangle.height) / 2.0, SVGImageFigure.this.bufferedImage.getWidth(), SVGImageFigure.this.bufferedImage.getHeight());
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, object, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
            }
            if (Math.abs((d2 = (double)this.bufferedImage.getHeight() / (double)this.bufferedImage.getWidth()) - (d = this.rectangle.height / this.rectangle.width)) > 0.001) {
                linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.adjustHeightToImageAspect.text")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        double d = (double)SVGImageFigure.this.bufferedImage.getHeight() * ((SVGImageFigure)SVGImageFigure.this).rectangle.width / (double)SVGImageFigure.this.bufferedImage.getWidth();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x, ((SVGImageFigure)SVGImageFigure.this).rectangle.y - (d - ((SVGImageFigure)SVGImageFigure.this).rectangle.height) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.width, d);
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, object, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
                linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.adjustWidthToImageAspect.text")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = SVGImageFigure.this.getTransformRestoreData();
                        SVGImageFigure.this.willChange();
                        double d = (double)SVGImageFigure.this.bufferedImage.getWidth() * ((SVGImageFigure)SVGImageFigure.this).rectangle.height / (double)SVGImageFigure.this.bufferedImage.getHeight();
                        SVGImageFigure.this.rectangle = new Rectangle2D.Double(((SVGImageFigure)SVGImageFigure.this).rectangle.x - (d - ((SVGImageFigure)SVGImageFigure.this).rectangle.width) / 2.0, ((SVGImageFigure)SVGImageFigure.this).rectangle.y, d, ((SVGImageFigure)SVGImageFigure.this).rectangle.height);
                        SVGImageFigure.this.fireUndoableEditHappened(new TransformRestoreEdit(SVGImageFigure.this, object, SVGImageFigure.this.getTransformRestoreData()));
                        SVGImageFigure.this.changed();
                    }
                });
            }
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public SVGImageFigure clone() {
        SVGImageFigure sVGImageFigure = (SVGImageFigure)super.clone();
        sVGImageFigure.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        sVGImageFigure.cachedTransformedShape = null;
        sVGImageFigure.cachedHitShape = null;
        return sVGImageFigure;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double double_ = this.getBounds();
        return double_.width <= 0.0 || double_.height <= 0.0 || this.imageData == null && this.bufferedImage == null;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateTransformedShape();
    }

    @Override
    public void setImage(byte[] byArray, BufferedImage bufferedImage) {
        this.willChange();
        this.imageData = byArray;
        this.bufferedImage = bufferedImage;
        this.changed();
    }

    public void setImageData(byte[] byArray) {
        this.willChange();
        this.imageData = byArray;
        this.bufferedImage = null;
        this.changed();
    }

    @Override
    public void setBufferedImage(BufferedImage bufferedImage) {
        this.willChange();
        this.imageData = null;
        this.bufferedImage = bufferedImage;
        this.changed();
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null && this.imageData != null) {
            try {
                this.bufferedImage = ImageIO.read(new ByteArrayInputStream(this.imageData));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.imageData = null;
            }
        }
        return this.bufferedImage;
    }

    @Override
    public byte[] getImageData() {
        if (this.bufferedImage != null && this.imageData == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.bufferedImage, "PNG", byteArrayOutputStream);
                byteArrayOutputStream.close();
                this.imageData = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.bufferedImage = null;
            }
        }
        return this.imageData;
    }

    @Override
    public void loadImage(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.loadImage(fileInputStream);
        }
        catch (Throwable throwable) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            IOException iOException = new IOException(resourceBundleUtil.getFormatted("file.failedToLoadImage.message", file.getName()));
            iOException.initCause(throwable);
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    @Override
    public void loadImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Throwable throwable) {
            bufferedImage = null;
        }
        if (bufferedImage == null) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            throw new IOException(resourceBundleUtil.getFormatted("file.failedToLoadImage.message", inputStream.toString()));
        }
        this.imageData = byteArrayOutputStream.toByteArray();
        this.bufferedImage = bufferedImage;
    }
}

