/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;

public class Actions {
    public static final String SELECTED_KEY = "selected";
    public static final String SUBMENU_KEY = "submenu";
    public static final String BUTTON_GROUP_KEY = "buttonGroup";
    public static final String UNDO_PRESENTATION_NAME_KEY = "undoPresentationName";

    private Actions() {
    }

    public static void configureJCheckBoxMenuItem(final JCheckBoxMenuItem jCheckBoxMenuItem, final Action action) {
        jCheckBoxMenuItem.setSelected((Boolean)action.getValue(SELECTED_KEY));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(Actions.SELECTED_KEY)) {
                    jCheckBoxMenuItem.setSelected((Boolean)action.getValue(Actions.SELECTED_KEY));
                }
            }
        };
        action.addPropertyChangeListener(propertyChangeListener);
        jCheckBoxMenuItem.putClientProperty("actionPropertyHandler", propertyChangeListener);
    }

    public static void unconfigureJCheckBoxMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem, Action action) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jCheckBoxMenuItem.getClientProperty("actionPropertyHandler");
        if (propertyChangeListener != null) {
            action.removePropertyChangeListener(propertyChangeListener);
            jCheckBoxMenuItem.putClientProperty("actionPropertyHandler", null);
        }
    }
}

