-- $Name:Навчання$

instead_version "1.6.0"

require "dash" -- '--' replace :)
require "para" -- be more "Russian"
require "quotes"

game.act = 'Не виходить.';
game.inv = "Гм.. Не те..";
game.use = 'Не спрацює...';

game.pic = 'instead.png';

set_music('instead.ogg');

main = room {
	nam = 'Навчання',
	act = function() -- only one vobj, no check, just goto
		walk('r1');
	end,
	dsc = txtc("Вітаємо в режимі навчання INSTEAD.")..[[^^
	Гра складається зі сцен. Кожна сцена гри має опис,
	що складається зі статичної та динамічної частини. Динамічна частина включає об'єкти,
	персонажі й т.і. З динамічною частиною гравець може взаємодіяти за допомогою миші, 
	нажимаючи на підсвічені посилання.^^

	Дана сцена має назву "Навчання" і зараз Ви читаєте статичну частину її опису.
	Єдиним об'єктом сцени є об'єкт "Далі", котрий Ви бачите внизу тексту.
	Отже, для продовження навчання Ви можете натиснути на "Далі".]],
	obj = { 
		vobj('continue', '{Далі}'),
	},
};

paper = obj {
	nam = 'папір',
	dsc = 'Перше, що Ви помічаєте в кімнаті -- {аркуш паперу}.',
	tak = 'Ви взяли папір.',
	var { seen = false, haswriting = false },
	inv = function(s)
		if here() == r2 then
			s.seen = true;
		end
		if not s.haswriting then
			return 'Чистий аркуш картатого паперу. Схоже, його вирвали з зошита.';
		end
		p 'Аркуш картатого паперу, на якому написано Ваше ім`я.';
	end,
	used = function(s, w)
		if w == pencil and here() == r4 then
			s.haswriting = true;
			p 'Ви пишите на аркуші своє ім`я.';
		end
	end,
};

pencil = obj {
	nam = 'олівець',
	dsc = 'На підлозі лежить {олівець}.',
	tak = 'Ви підібрали олівець.',
	var { seen = false },
	inv = function(s)
		if here() == r2 then
			s.seen = true;
		end
		p 'Звичайний дерев`яний олівець.';
	end,
};

r1 = room {
	nam = 'Урок 1',
	enter = code [[ lifeon('r1') ]],
	life = function(s)
		if not have 'paper' or not have 'pencil' then
			return
		end
		put(vway('continue',
		[[Відмінно!^Ви, швидше за все помітили, що статична частина опису сцени
		зникла, поступившись місцем опису предметів, котрі Ви взяли.
		Щоб знову подивитись повний опис сцени, можна нажати на її
		назву, відображену у верхній частині вікна -- "Урок 1". Окрім того,
		можна нажати клавішу F5 на клавіатурі, результат буде такий само.^^
		{Далі}]], 'r2'));
		lifeoff('r1');
	end,
	dsc = [[Урок 1. Взаємодія з об`єктами^^
		Продовжимо урок. Зараз Ви знаходитесь в кімнаті. Візьміть обидва предмети, 
		котрі Ви бачите. Нагадаємо, що для цього Ви можете просто
		використовувати мишу. Якщо Вам зручніше використовувати клавіатуру -- можна
	обрати потрібний предмет за допомогою клавіш зі стрілками и натиснути "Введення" для
	взаємодії з ними.]],
	obj = { 'paper', 'pencil'},
};

r2 = room {
	nam = 'Урок 2',
	enter = code [[ lifeon('r2') ]],
	life = function(s)
		if not paper.seen or not pencil.seen then
			return
		end
		put(vway("continue", "Гарно!^^{Далі}", 'r3'));
		lifeoff('r2');
	end,
	dsc = [[Урок 2. Використання інвентарю - Частина I^^
		Тепер у Вас з'явилися предмети, котрі можно використовувати чи вивчати.
		Для цього призначений інвентар. Ви можете подивитися на будь-який предмет 
		інвентарю двічи клацнувши мишею по цьому предмету. Те ж саме можна
		зробити за допомогою клавіатури: нажміть "Tab", щоб перемкнутися на панель 
		інвентарю, оберіть потрібний предмет і двічі
		нажміть "Введення". Щоб повернутися назад до опису сцени, нажмить "Tab" ще раз.^^

		Отже, подивіться на папір. Потім, повторіть цю операцію з олівцем.]],
};

apple = obj {
	nam = 'яблуко',
	dsc = 'На столі лежить {яблуко}.',
	tak = 'Ви взяли яблуко зі столу.',
	var { knife = false },
	inv = function(s)
		if here() == r4 then
			remove(s, me());
			return 'Вы з`їдаєте яблуко.';
		end
		p 'Виглядає апетитно.';
	end,
};

desk = obj {
	nam = 'стіл',
	dsc = 'В цьому уроці ви бачите дерев`яний {письмовий стіл}.',
	var { haswriting = false, seen = false },
	act = function(s)
		if s.haswriting then
			s.seen = true;
			return 'Великий дубовий письмовий стіл. На стільниці видно дрібний напис олівцем: "Любіть Україну".';
		end
		p 'Великий дубовий письмовий стіл.';
	end,
	used = function(s, w)
		if w == pencil and not s.haswriting then
			s.haswriting = true;
			p 'Ви пишете на столешні декілька літер.';
		end
	end,
	obj = { 'apple' },
};

r3 = room {
	nam = 'Урок 3',
	enter = code [[ lifeon('r3') ]],
	life = function(s)
		if not desk.seen or not have('apple') then
			return
		end
		put(vway("continue", "^^{Далі}", 'r4'));
		lifeoff('r3');
	end,
	dsc = [[Урок 3. Використання інвентаря - Частина II^^
		Ви можете задіяти предмети інвентарю на інші предмети сцени чи інвентарю. 
		В цій комнаті ви бачите стіл. Спробуйте задіяти олівець на стіл.^^ 

		Для цього клацніть мишей на олівець, а потім на стіл. Те ж саме можна зробити
		за допомогою клавіатури: використовуючи клавіши "Tab", "Введення" й "стрілки".^^
  
		Потім подивіться на стіл. І не забудьте взяти яблуко, воно нам знадобиться в наступному уроці.]],
	obj = { 'desk' },
};

r4 = room {
	nam = 'Урок 4',  
	enter = function()
		apple.knife = false;
		lifeon('r4');
	end,
	life = function(s)
		if not paper.haswriting or have('apple') then
			return
		end
		put(vway("continue", "Гаразд.^^{Далі}", 'r5'));
		lifeoff('r4');
	end,
	dsc = [[Урок 4. Використання інвентарю - Частина III^^
		Гаразд, тепер вивчимо ще декілька дій з предметами.^^
	
		По-перше, напішить що-небудь на папері. Для цього нажміть мишею 
		на олівець, а потім на папір. Після цього ви можете подивитись
		на папір, щоб побачити ваш запис.^^
	
		По-друге, з'їште яблуко, котре Ви взяли зі столу в попередній кімнаті. 
		Для цього двічи клацніть по яблуку в інвентарі.^^

		Всі описані дії можна виконати за допомогою клавіатури так само, 
		як показано в попередньому уроці.]],
};

r5 = room {
	nam = 'Урок 5',
	exit = function(s, t)
		if t ~= r6 then
			return 'Цей урок ми вже пройшли.^ Будь ласка, перейдіть на урок 6.', false;
		end
	end,
	dsc = [[Урок 5. Переміщення - Частина I^^
		Тепер вивчимо переходи між кімнатами. В цій кімнаті Ви бачите п'ять 
		допоміжних посилань з номерами уроків. Перейдіть на урок 6. ^^

		Для цього натисніть мишею на відповідне посилання. Ви також можете використати
		клавіатуру -- виберіть потрібне посилання за допомогою клавіш зі стрілками 
		та нажміть "Введення" для переходу.]],
	way = { 'r1', 'r2', 'r3', 'r4', 'r6'},
};

r6 = room {
	nam = 'Урок 6',
	exit = function(s, t)
		if t ~= theend then
			p 'Цей урок ми вже пройшли.^ Будь ласка, перейдіть на останній урок.'
			return false; -- same as return "text", false
		end
	end,
	dsc = [[Урок 6. Переміщення - Частина II^^
		Тепер перейдіть на останній урок.]],
	way = { 'r1', 'r2', 'r3', 'r4', 'r5', 'theend'},
};

theend = room {
	nam = 'Останній урок',
	dsc = [[Ви можете вибирати гру, зберігати та завантажувати її стан і виконувати
		інші дії за допомогою меню. Для виклику меню натисніть клавішу "Esc" або 
		натисніть мишею на символ меню (справа знизу).^^
		Тепер Ви готові до гри. Хай щастить!!!^^
		Ігри для INSTEAD можно завантажити тут: ]]..txtu("http://instead.syscall.ru")..[[^^
		Для навчання використан трек "Instead game-engine" вiд svenzzon.]],
	obj = { vway('keys', 'Подивитись {список клавіш}.', 'help')},
};

help = room {
	nam = 'Список клавіш',
	dsc = [[
	Esc - Виклик меню;^
	Alt+Q - Вихід;^
	Alt+Enter - Повноекранний/віконний режим;^
	F5 - Оновлення сцени;^
	Пробел/Backspace - Прокрутка опису сцени;^
	Tab/Shift+Tab - Переключення між активними зонами;^
	PgUp/PgDn - Прокрутка активної зони;^
	Стрілки вліво/вправо - Вибір посиланнь в активній зоні;^
	F2 - Збереження гри;^
	F3 - Завантаження гри;^
	F8 - Швидке збереження гри;^
	F9 - Швидке завантаження гри.^^

	Клавіши, поведінка яких залежить від обраного режиму клавіатури
	(див. Меню -> Налаштування -> Режим клавіатури):^^

	Стрілки вгору/вниз:^
	 - В режимі "Прокрутка": прокрутка активної зони;^
	 - В режимі "Посилання": вибір посиланнь в активній зоні;^
	 - В режимі "Розумний": одночасний вибір посиланнь та прокрутка активної зони.^^

	Стрілки вгору/вниз + Shift або Alt:^
	 - В режимі "Прокрутка": вибір посиланнь в активній зоні;^
	 - В режимі "Посилання": прокрутка активної зони;^
	 - В режимі "Розумний": прокрутка активної зони.
	]],
	obj = { vway('cmdline', 'Подивитись {параметри командного рядка}.', 'help2')},
};

help2 = room {
	nam = 'Параметри командного рядка',
	dsc = [[
	-nosound - запуск без звуку;^
	-debug - режим налагоджування для розробників ігр;^
	-theme <тема> - вибір теми;^
	-game <гра> - вибір гри;^
	-themespath <шлях> - додатковий шлях до тем;^
	-gamespath <шлях> - додатковий шлях до ігр;^
	-windows - віконний режим;^
	-fullscreen - повноекранний режим;^
	-noautosave - відключити автозбереження/автозагрузку;^
	-encode <game.lua> [encoded.lua] - закодувати вихідний текст lua (використовуйте doencfile для загрузки такого файла);^
	-mode [ШИРИНАxВИСОТА] - встановити роздільну здатність екрану.
	]],
	obj = { vway('keys', 'Подивитись {список клавіш}.', 'help')},
};
