# Copyright 2017 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The `domains list-user-verified` command."""

from googlecloudsdk.api_lib.app.api import appengine_domains_api_client as api_client
from googlecloudsdk.calliope import base


class ListUserVerified(base.Command):
  """Lists the user's verified domains."""

  detailed_help = {
      'DESCRIPTION':
          '{description}',
      'EXAMPLES':
          """\
          To list domains that have been verified by the current user, run:

            $ {command} list-user-verified

          Use the {parent_command} verify command to verify additional
          domains.
          """,
  }

  def Run(self, args):
    client = api_client.AppengineDomainsApiClient.GetApiClient()
    return client.ListVerifiedDomains()

  def DeprecatedFormat(self, args):
    return """
            table(
              id:sort=1
            )
          """
