/*	$OpenBSD: bold8x16-iso1.h,v 1.4 2012/01/06 14:55:38 shadchin Exp $ */

/*-
 * Copyright (c) 1999 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Andrew Doran.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This font lives in the public domain. It's based on the bold8x16 font.
 * This font is ISO 8859-1 encoded.
 */
static u_char bold8x16_iso1_data[];

struct wsdisplay_font bold8x16_iso1 = {
	"Boldface.iso1",		/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	256 - ' ',			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	8,				/* width */
	16,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	bold8x16_iso1_data		/* data */
};

static u_char bold8x16_iso1_data[] = {
	/*   */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ! */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* " */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x77, 	/* .***.*** */
	0x66, 	/* .**..**. */
	0xcc, 	/* **..**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* # */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* $ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x7c, 	/* .*****.. */
	0xd6, 	/* **.*.**. */
	0xd0, 	/* **.*.... */
	0xd0, 	/* **.*.... */
	0x7c, 	/* .*****.. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0xd6, 	/* **.*.**. */
	0x7c, 	/* .*****.. */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* % */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc4, 	/* **...*.. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x46, 	/* .*...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* & */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x76, 	/* .***.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ' */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ( */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ) */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* * */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* + */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* , */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* - */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* . */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* / */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x04, 	/* .....*.. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0x18, 	/* ...**... */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 1 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 3 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x3c, 	/* ..****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x1c, 	/* ...***.. */
	0x3c, 	/* ..****.. */
	0x6c, 	/* .**.**.. */
	0xcc, 	/* **..**.. */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 5 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* : */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ; */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* < */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* = */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* > */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ? */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x1c, 	/* ...***.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* @ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xdc, 	/* **.***.. */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* A */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* C */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* D */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* E */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* G */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* H */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* I */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* J */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* K */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xf0, 	/* ****.... */
	0xe0, 	/* ***..... */
	0xe0, 	/* ***..... */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* L */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* M */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xee, 	/* ***.***. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* N */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xf6, 	/* ****.**. */
	0xfe, 	/* *******. */
	0xde, 	/* **.****. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* O */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* P */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Q */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xf6, 	/* ****.**. */
	0xde, 	/* **.****. */
	0x7c, 	/* .*****.. */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* R */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* S */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0x60, 	/* .**..... */
	0x38, 	/* ..***... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* T */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* U */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* V */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* W */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xee, 	/* ***.***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* X */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Y */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Z */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* [ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x10, 	/* ...*.... */
	0x18, 	/* ...**... */
	0x08, 	/* ....*... */
	0x0c, 	/* ....**.. */
	0x04, 	/* .....*.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ] */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ^ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* _ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ` */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* a */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* b */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* c */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* d */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* e */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* f */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* g */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/* h */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* i */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* j */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */

	/* k */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* l */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* m */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xec, 	/* ***.**.. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* n */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* o */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* p */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */

	/* q */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */

	/* r */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* s */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc0, 	/* **...... */
	0x70, 	/* .***.... */
	0x1c, 	/* ...***.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* t */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0xfc, 	/* ******.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* u */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* v */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* w */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* x */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* y */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/* z */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* { */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0e, 	/* ....***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* | */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* } */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ~ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0177 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0200 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0201 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0202 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0203 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0204 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0205 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0206 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0207 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0210 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0211 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0212 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0213 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0214 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0215 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0216 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0217 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0220 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0221 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0222 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0223 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0224 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0225 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0226 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0227 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0230 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0231 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0232 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0233 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0234 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0235 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0236 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \0237 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* NBSP */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0xc3, 	/* **....** */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc3, 	/* **....** */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x66, 	/* .**..**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6,	/* **...**. */
	0x38,	/* ..***... */
	0x6c,	/* .**.**.. */
	0x44,	/* .*...*.. */
	0x6c,	/* .**.**.. */
	0x38,	/* ..***... */
	0xc6,	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x60, 	/* .**..... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x0c, 	/* ....**.. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x82, 	/* *.....*. */
	0x92, 	/* *..*..*. */
	0xaa, 	/* *.*.*.*. */
	0xa2, 	/* *.*...*. */
	0xaa, 	/* *.*.*.*. */
	0x92, 	/* *..*..*. */
	0x82, 	/* *.....*. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x36, 	/* ..**.**. */
	0x6c, 	/* .**.**.. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x6c, 	/* .**.**.. */
	0x36, 	/* ..**.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x82, 	/* *.....*. */
	0x92, 	/* *..*..*. */
	0xaa, 	/* *.*.*.*. */
	0xb2, 	/* *.**..*. */
	0xaa, 	/* *.*.*.*. */
	0xaa, 	/* *.*.*.*. */
	0x82, 	/* *.....*. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0xd8, 	/* **.**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0xd8, 	/* **.**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x7c, 	/* .*****.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xf4, 	/* ****.*.. */
	0xf4, 	/* ****.*.. */
	0xf4, 	/* ****.*.. */
	0x74, 	/* .***.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x70, 	/* .***.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xd8, 	/* **.**... */
	0x6c, 	/* .**.**.. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x6c, 	/* .**.**.. */
	0xd8, 	/* **.**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x70, 	/* .***.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0e, 	/* ....***. */
	0x16, 	/* ...*.**. */
	0x3e, 	/* ..*****. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x70, 	/* .***.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x36, 	/* ..**.**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x3e, 	/* ..*****. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0xd8, 	/* **.**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0e, 	/* ....***. */
	0x16, 	/* ...*.**. */
	0x3e, 	/* ..*****. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3e, 	/* ..*****. */
	0x6c, 	/* .**.**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xfe, 	/* *******. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xce, 	/* **..***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	/*  */
	0x60, 	/* .**.... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x6c, 	/* .**.**.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0xf6, 	/* ****.**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x6c, 	/* .**.**.. */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xf6, 	/* ****.**. */
	0xfe, 	/* *******. */
	0xde, 	/* **.****. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* .**.**.. */
	0x6c, 	/* **...**. */
	0xc6, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xce, 	/* **..***. */
	0xce, 	/* **..***. */
	0xce, 	/* **..***. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xe6, 	/* ***..**. */
	0xe6, 	/* ***..**. */
	0xe6, 	/* ***..**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x7c, 	/* .*****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x7c, 	/* .*****.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc4, 	/* **...*.. */
	0xc8, 	/* **..*... */
	0xc4, 	/* **...*.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xdc, 	/* **.***.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xdb, 	/* **.**.** */
	0x1b, 	/* ...**.** */
	0x7f, 	/* .******* */
	0xd8, 	/* **.**... */
	0xdb, 	/* **.**.** */
	0x6e, 	/* .**.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x02, 	/* ......*. */
	0x3e, 	/* ..*****. */
	0x46, 	/* .*...**. */
	0xce, 	/* **..***. */
	0xd6, 	/* **.*.**. */
	0xe6, 	/* ***..**. */
	0xc4, 	/* **...*.. */
	0xf8, 	/* *****... */
	0x80, 	/* *....... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x7c, 	/* .*****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x7c, 	/* .*****.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */

	/*  */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
};
